/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.api.utils;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;

public enum ServerVersion {
    v1_21_11("1.21.11 Pre-Release 4", 774),
    v1_21_10("1.21.10", 773),
    v1_21_9("1.21.9", 773),
    v1_21_8("1.21.8", 772),
    v1_21_7("1.21.7", 772),
    v1_21_6("1.21.6", 771),
    v1_21_5("1.21.5", 770),
    v1_21_4("1.21.4", 769),
    v1_21_3("1.21.3", 768),
    v1_21_1("1.21.1", 767),
    v1_21("1.21", 767),
    v1_20_6("1.20.6", 766),
    v1_20_5("1.20.5", 766);

    private final String version;
    private final int protocolVersion;

    private ServerVersion(String version, int protocolVersion) {
        this.version = version;
        this.protocolVersion = protocolVersion;
    }

    public static ServerVersion getByProtocolVersion(int protocolVersion) {
        for (ServerVersion version : ServerVersion.values()) {
            if (version.getProtocolVersion() != protocolVersion) continue;
            return version;
        }
        return null;
    }

    public static ServerVersion getByVersion(String version) {
        for (ServerVersion serverVersion : ServerVersion.values()) {
            if (!serverVersion.getVersion().equals(version)) continue;
            return serverVersion;
        }
        return null;
    }

    public static List<String> getSupportedVersions() {
        return Arrays.stream(ServerVersion.values()).map(ServerVersion::getVersion).toList();
    }

    public static boolean isVersionSupported(String version) {
        return ServerVersion.getByVersion(version) != null;
    }

    public static ServerVersion getCurrentVersion() {
        return ServerVersion.getByVersion(Bukkit.getMinecraftVersion());
    }

    public String getVersion() {
        return this.version;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }
}

