/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api.data;

import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.api.hologram.HologramType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.ApiStatus;

public class TextHologramData
extends DisplayHologramData {
    public static final List<String> DEFAULT_TEXT = List.of("Edit this line with /hologram edit <name>");
    public static final TextDisplay.TextAlignment DEFAULT_TEXT_ALIGNMENT = TextDisplay.TextAlignment.CENTER;
    public static final boolean DEFAULT_TEXT_SHADOW_STATE = false;
    public static final boolean DEFAULT_SEE_THROUGH = false;
    public static final int DEFAULT_TEXT_UPDATE_INTERVAL = -1;
    private List<String> text = new ArrayList<String>(DEFAULT_TEXT);
    private Color background = null;
    private TextDisplay.TextAlignment textAlignment = DEFAULT_TEXT_ALIGNMENT;
    private boolean textShadow = false;
    private boolean seeThrough = false;
    private int textUpdateInterval = -1;

    public TextHologramData(String name, Location location) {
        super(name, HologramType.TEXT, location);
    }

    public List<String> getText() {
        return this.text;
    }

    public TextHologramData setText(List<String> text) {
        if (!Objects.equals(this.text, text)) {
            this.text = text;
            this.setHasChanges(true);
        }
        return this;
    }

    public TextHologramData addLine(String line) {
        this.text.add(line);
        this.setHasChanges(true);
        return this;
    }

    public TextHologramData removeLine(int index) {
        this.text.remove(index);
        this.setHasChanges(true);
        return this;
    }

    public TextHologramData setLine(int index, String line) {
        this.text.set(index, line);
        this.setHasChanges(true);
        return this;
    }

    public TextHologramData clearText() {
        this.text.clear();
        this.setHasChanges(true);
        return this;
    }

    public Color getBackground() {
        return this.background;
    }

    public TextHologramData setBackground(Color background) {
        if (!Objects.equals(this.background, background)) {
            this.background = background;
            this.setHasChanges(true);
        }
        return this;
    }

    public TextHologramData setBackground(String background) {
        if (background == null || background.equalsIgnoreCase("")) {
            return this;
        }
        String hex = background.substring(1);
        int argb = (int)Long.parseLong(hex, 16);
        return this.setBackground(Color.fromARGB((int)argb));
    }

    public TextDisplay.TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public TextHologramData setTextAlignment(TextDisplay.TextAlignment textAlignment) {
        if (!Objects.equals(this.textAlignment, textAlignment)) {
            this.textAlignment = textAlignment;
            this.setHasChanges(true);
        }
        return this;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public TextHologramData setTextShadow(boolean textShadow) {
        if (this.textShadow != textShadow) {
            this.textShadow = textShadow;
            this.setHasChanges(true);
        }
        return this;
    }

    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    public TextHologramData setSeeThrough(boolean seeThrough) {
        if (this.seeThrough != seeThrough) {
            this.seeThrough = seeThrough;
            this.setHasChanges(true);
        }
        return this;
    }

    public int getTextUpdateInterval() {
        return this.textUpdateInterval;
    }

    public TextHologramData setTextUpdateInterval(int textUpdateInterval) {
        if (this.textUpdateInterval != textUpdateInterval) {
            this.textUpdateInterval = textUpdateInterval;
            this.setHasChanges(true);
        }
        return this;
    }

    @Override
    @ApiStatus.Internal
    public boolean read(ConfigurationSection section, String name) {
        super.read(section, name);
        this.text = section.getStringList("text");
        if (this.text.isEmpty()) {
            this.text = List.of("Could not load hologram text");
        }
        this.textShadow = section.getBoolean("text_shadow", false);
        this.seeThrough = section.getBoolean("see_through", false);
        this.textUpdateInterval = section.getInt("update_text_interval", -1);
        String textAlignmentStr = section.getString("text_alignment", DEFAULT_TEXT_ALIGNMENT.name().toLowerCase());
        this.textAlignment = switch (textAlignmentStr.toLowerCase(Locale.ROOT)) {
            case "right" -> TextDisplay.TextAlignment.RIGHT;
            case "left" -> TextDisplay.TextAlignment.LEFT;
            default -> TextDisplay.TextAlignment.CENTER;
        };
        this.background = null;
        String backgroundStr = section.getString("background", null);
        if (backgroundStr != null) {
            if (backgroundStr.equalsIgnoreCase("transparent")) {
                this.background = Hologram.TRANSPARENT;
            } else if (backgroundStr.startsWith("#")) {
                this.background = Color.fromARGB((int)((int)Long.parseLong(backgroundStr.substring(1), 16)));
                if (backgroundStr.length() == 7) {
                    this.background = this.background.setAlpha(255);
                }
            } else {
                this.background = Color.fromARGB((int)(((NamedTextColor)NamedTextColor.NAMES.value((Object)backgroundStr.toLowerCase(Locale.ROOT).trim().replace(' ', '_'))).value() | 0xC8000000));
            }
        }
        return true;
    }

    @Override
    @ApiStatus.Internal
    public boolean write(ConfigurationSection section, String name) {
        String color;
        super.write(section, name);
        section.set("text", this.text);
        section.set("text_shadow", (Object)this.textShadow);
        section.set("see_through", (Object)this.seeThrough);
        section.set("text_alignment", (Object)this.textAlignment.name().toLowerCase(Locale.ROOT));
        section.set("update_text_interval", (Object)this.textUpdateInterval);
        if (this.background == null) {
            color = null;
        } else if (this.background == Hologram.TRANSPARENT) {
            color = "transparent";
        } else {
            NamedTextColor named = this.background.getAlpha() == 255 ? NamedTextColor.namedColor((int)this.background.asRGB()) : null;
            color = named != null ? named.toString() : "#" + Integer.toHexString(this.background.asARGB());
        }
        section.set("background", (Object)color);
        return true;
    }

    @Override
    public TextHologramData copy(String name) {
        TextHologramData textHologramData = new TextHologramData(name, this.getLocation());
        textHologramData.setText(this.getText()).setBackground(this.getBackground()).setTextAlignment(this.getTextAlignment()).setTextShadow(this.hasTextShadow()).setSeeThrough(this.isSeeThrough()).setTextUpdateInterval(this.getTextUpdateInterval()).setScale(this.getScale()).setShadowRadius(this.getShadowRadius()).setShadowStrength(this.getShadowStrength()).setBillboard(this.getBillboard()).setTranslation(this.getTranslation()).setBrightness(this.getBrightness()).setVisibilityDistance(this.getVisibilityDistance()).setVisibility(this.getVisibility()).setPersistent(this.isPersistent()).setLinkedNpcName(this.getLinkedNpcName());
        return textHologramData;
    }
}

