/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.fancyinnovations.fancyholograms.util.Formats;
import com.google.common.primitives.Ints;
import de.oliver.fancylib.MessageHelper;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!player.hasPermission("fancyholograms.hologram.list")) {
            MessageHelper.error(player, "You don't have the required permission to list the holograms");
            return false;
        }
        Collection<Hologram> holograms = FancyHologramsPlugin.get().getRegistry().getAllPersistent();
        if (holograms.isEmpty()) {
            MessageHelper.warning(player, "There are no holograms. Use '/hologram create' to create one");
        } else {
            int page;
            if (args.length < 2) {
                page = 1;
            } else {
                Integer index = Ints.tryParse((String)args[1]);
                if (index == null) {
                    MessageHelper.error(player, "Could not parse page number");
                    return false;
                }
                page = index;
            }
            int pages = holograms.size() / 10 + 1;
            if (page > pages) {
                MessageHelper.error(player, "Page %s does not exist".formatted(page));
                return true;
            }
            MessageHelper.info(player, "<b>List of holograms:</b>");
            MessageHelper.info(player, "<b>Page %s/%s</b>".formatted(page, pages));
            holograms.stream().skip((page - 1) * 10).limit(10L).forEach(holo -> {
                Location location = holo.getData().getLocation();
                if (location == null || holo.getData().getWorldName() == null) {
                    return;
                }
                MessageHelper.info(player, "<hover:show_text:'<gray><i>Click to teleport</i></gray>'><click:run_command:'%s'> - %s (%s/%s/%s in %s)</click></hover>".formatted("/hologram teleport " + holo.getData().getName(), holo.getData().getName(), Formats.DECIMAL.format(location.x()), Formats.DECIMAL.format(location.y()), Formats.DECIMAL.format(location.z()), holo.getData().getWorldName()));
            });
        }
        return true;
    }
}

