/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.lampCommands.fancyholograms;

import com.fancyinnovations.config.Config;
import com.fancyinnovations.config.ConfigField;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.translations.Translator;
import java.util.Comparator;
import java.util.List;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Description;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.annotation.CommandPermission;

public final class ConfigCMD {
    public static final ConfigCMD INSTANCE = new ConfigCMD();
    private final FancyHologramsPlugin plugin = FancyHologramsPlugin.get();
    private final Translator translator = FancyHologramsPlugin.get().getTranslator();

    private ConfigCMD() {
    }

    @Command(value={"fancyholograms-new config show"})
    @Description(value="Shows the current configuration")
    @CommandPermission(value="fancyholograms.commands.fancyholograms.config.show")
    public void show(BukkitCommandActor actor) {
        Config config = this.plugin.getFHConfiguration().getConfig();
        List<ConfigField> fields = config.getFields().values().stream().sorted(Comparator.comparing(ConfigField::path)).toList();
        this.translator.translate("commands.fancyholograms.config.show.settings_header").send(actor.sender());
        for (ConfigField field : fields) {
            if (!field.path().startsWith("settings.")) continue;
            this.translator.translate("commands.fancyholograms.config.show.entry").replace("path", field.path().substring("settings.".length())).replace("value", config.get(field.path()).toString()).replace("default", String.valueOf(field.defaultValue())).send(actor.sender());
        }
        actor.sender().sendMessage(" ");
        this.translator.translate("commands.fancyholograms.config.show.experimental_header").send(actor.sender());
        for (ConfigField field : fields) {
            if (!field.path().startsWith("experimental_features.")) continue;
            this.translator.translate("commands.fancyholograms.config.show.entry").replace("path", field.path().substring("experimental_features.".length())).replace("value", config.get(field.path()).toString()).replace("default", String.valueOf(field.defaultValue())).send(actor.sender());
        }
    }
}

