/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.trait;

import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitClass;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitRegistry;
import java.util.HashMap;
import java.util.List;

public class HologramTraitRegistryImpl
implements HologramTraitRegistry {
    private final HashMap<String, HologramTraitRegistry.TraitInfo> traits = new HashMap();

    @Override
    public void register(Class<? extends HologramTrait> trait) {
        HologramTraitRegistry.TraitInfo info = this.getInfo(trait);
        this.traits.put(info.name(), info);
    }

    @Override
    public void unregister(Class<? extends HologramTrait> trait) {
        HologramTraitRegistry.TraitInfo info = this.getInfo(trait);
        this.traits.remove(info.name());
    }

    @Override
    public boolean isRegistered(Class<? extends HologramTrait> trait) {
        HologramTraitRegistry.TraitInfo info = this.getInfo(trait);
        return this.traits.containsKey(info.name());
    }

    @Override
    public HologramTraitRegistry.TraitInfo getTrait(String name) {
        return this.traits.get(name);
    }

    @Override
    public List<HologramTraitRegistry.TraitInfo> getTraits() {
        return List.copyOf(this.traits.values());
    }

    private HologramTraitRegistry.TraitInfo getInfo(Class<? extends HologramTrait> trait) {
        if (trait.isAnnotationPresent(HologramTraitClass.class)) {
            String name = trait.getAnnotation(HologramTraitClass.class).traitName();
            boolean isDefault = trait.getAnnotation(HologramTraitClass.class).defaultTrait();
            return new HologramTraitRegistry.TraitInfo(name, trait, isDefault);
        }
        throw new IllegalArgumentException("Trait class " + trait.getName() + " is not annotated with HologramTraitClass");
    }
}

