/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.trait.builtin;

import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.trait.HologramTrait;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitClass;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;

@HologramTraitClass(traitName="file_content_trait")
@ApiStatus.Experimental
public class FileContentTrait
extends HologramTrait {
    private static final Configuration DEFAULT_CONFIG = new Configuration("server.properties", 1000L);
    private Configuration config;

    @Override
    public void onAttach() {
        if (!(this.hologram.getData() instanceof TextHologramData)) {
            throw new IllegalStateException("Hologram must be text hologram to use FileContentTrait");
        }
        this.load();
        if (this.config.refreshInterval > 0L) {
            this.hologramThread.scheduleWithFixedDelay(this::updateHologram, 0L, this.config.refreshInterval(), TimeUnit.MILLISECONDS);
        } else {
            this.updateHologram();
        }
    }

    public void updateHologram() {
        Path path = Paths.get(this.config.filePath(), new String[0]);
        if (!path.toFile().exists()) {
            this.logger.warn("File does not exist: " + this.config.filePath(), new Property[0]);
            return;
        }
        try {
            String content = Files.readString(path);
            List<String> lines = List.of(content.split("\\r?\\n"));
            ((TextHologramData)this.hologram.getData()).setText(lines);
        }
        catch (IOException e) {
            this.logger.error("Failed to read file content of: " + this.config.filePath(), ThrowableProperty.of(e));
        }
    }

    @Override
    public void load() {
        try {
            this.config = this.storage.get(this.hologram.getData().getName(), Configuration.class);
        }
        catch (IOException e) {
            this.logger.error("Failed to load configuration for FileContentTrait", ThrowableProperty.of(e));
        }
        if (this.config == null) {
            this.config = DEFAULT_CONFIG;
            this.save();
        }
    }

    @Override
    public void save() {
        try {
            this.storage.set(this.hologram.getData().getName(), this.config);
        }
        catch (IOException e) {
            this.logger.error("Failed to save configuration for FileContentTrait", ThrowableProperty.of(e));
        }
    }

    record Configuration(String filePath, long refreshInterval) {
    }
}

