/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancyholograms.commands;

import com.google.common.primitives.Ints;
import de.oliver.fancyholograms.FancyHolograms;
import de.oliver.fancyholograms.api.data.DisplayHologramData;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.events.HologramUpdateEvent;
import de.oliver.fancyholograms.api.hologram.Hologram;
import de.oliver.fancyholograms.api.hologram.HologramType;
import de.oliver.fancyholograms.commands.hologram.AddLineCMD;
import de.oliver.fancyholograms.commands.hologram.BackgroundCMD;
import de.oliver.fancyholograms.commands.hologram.BillboardCMD;
import de.oliver.fancyholograms.commands.hologram.BlockCMD;
import de.oliver.fancyholograms.commands.hologram.BrightnessCMD;
import de.oliver.fancyholograms.commands.hologram.CenterCMD;
import de.oliver.fancyholograms.commands.hologram.CopyCMD;
import de.oliver.fancyholograms.commands.hologram.CreateCMD;
import de.oliver.fancyholograms.commands.hologram.InfoCMD;
import de.oliver.fancyholograms.commands.hologram.InsertAfterCMD;
import de.oliver.fancyholograms.commands.hologram.InsertBeforeCMD;
import de.oliver.fancyholograms.commands.hologram.ItemCMD;
import de.oliver.fancyholograms.commands.hologram.LinkWithNpcCMD;
import de.oliver.fancyholograms.commands.hologram.ListCMD;
import de.oliver.fancyholograms.commands.hologram.MoveHereCMD;
import de.oliver.fancyholograms.commands.hologram.MoveToCMD;
import de.oliver.fancyholograms.commands.hologram.NearbyCMD;
import de.oliver.fancyholograms.commands.hologram.RemoveCMD;
import de.oliver.fancyholograms.commands.hologram.RemoveLineCMD;
import de.oliver.fancyholograms.commands.hologram.RotateCMD;
import de.oliver.fancyholograms.commands.hologram.RotatePitchCMD;
import de.oliver.fancyholograms.commands.hologram.ScaleCMD;
import de.oliver.fancyholograms.commands.hologram.SeeThroughCMD;
import de.oliver.fancyholograms.commands.hologram.SetLineCMD;
import de.oliver.fancyholograms.commands.hologram.ShadowRadiusCMD;
import de.oliver.fancyholograms.commands.hologram.ShadowStrengthCMD;
import de.oliver.fancyholograms.commands.hologram.TeleportCMD;
import de.oliver.fancyholograms.commands.hologram.TextAlignmentCMD;
import de.oliver.fancyholograms.commands.hologram.TextShadowCMD;
import de.oliver.fancyholograms.commands.hologram.TranslateCommand;
import de.oliver.fancyholograms.commands.hologram.UnlinkWithNpcCMD;
import de.oliver.fancyholograms.commands.hologram.UpdateTextIntervalCMD;
import de.oliver.fancyholograms.commands.hologram.VisibilityCMD;
import de.oliver.fancyholograms.commands.hologram.VisibilityDistanceCMD;
import de.oliver.fancyholograms.util.Constants;
import de.oliver.fancyholograms.util.PluginUtils;
import de.oliver.fancylib.MessageHelper;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.jetbrains.annotations.NotNull;

public final class HologramCMD
extends Command {
    @NotNull
    private final FancyHolograms plugin;

    public HologramCMD(@NotNull FancyHolograms plugin) {
        super("hologram", "Main command for the FancyHolograms plugin", "/hologram help", List.of("holograms", "holo", "fholo"));
        this.setPermission("fancyholograms.admin");
        this.plugin = plugin;
    }

    public static boolean callModificationEvent(@NotNull Hologram hologram, @NotNull CommandSender player, @NotNull HologramData updatedData, @NotNull HologramUpdateEvent.HologramModification modification) {
        boolean result = new HologramUpdateEvent(hologram, player, updatedData, modification).callEvent();
        if (!result) {
            MessageHelper.error(player, "Cancelled hologram modification");
        }
        return result;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            MessageHelper.info(sender, Constants.HELP_TEXT + (String)(!PluginUtils.isFancyNpcsEnabled() ? "" : "\n" + Constants.HELP_TEXT_NPCS));
            return false;
        }
        if (args[0].equalsIgnoreCase("list")) {
            return new ListCMD().run(sender, null, args);
        }
        if (args.length < 2) {
            MessageHelper.error(sender, "Wrong usage: /hologram help");
            return false;
        }
        if (args[0].equalsIgnoreCase("create")) {
            return new CreateCMD().run(sender, null, args);
        }
        if (args[0].equalsIgnoreCase("nearby")) {
            return new NearbyCMD().run(sender, null, args);
        }
        Hologram hologram = this.plugin.getHologramsManager().getHologram(args[1]).orElse(null);
        if (hologram == null) {
            MessageHelper.error(sender, "Could not find hologram: '" + args[1] + "'");
            return false;
        }
        return switch (args[0].toLowerCase(Locale.ROOT)) {
            case "info" -> new InfoCMD().run(sender, hologram, args);
            case "remove" -> new RemoveCMD().run(sender, hologram, args);
            case "teleport" -> new TeleportCMD().run(sender, hologram, args);
            case "copy" -> new CopyCMD().run(sender, hologram, args);
            case "edit" -> {
                if (args.length < 3) {
                    MessageHelper.error(sender, "Wrong usage: /hologram help");
                    yield false;
                }
                boolean updated = this.edit(sender, hologram, args);
                if (updated) {
                    if (sender instanceof Player) {
                        Player p = (Player)sender;
                        hologram.forceUpdate();
                        hologram.refreshHologram(p);
                    }
                    hologram.queueUpdate();
                }
                yield updated;
            }
            default -> false;
        };
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Stream.of("help", "list", "teleport", "create", "remove", "edit", "copy", "info", "nearby").filter(input -> input.startsWith(args[0].toLowerCase(Locale.ROOT))).toList();
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("create")) {
            return Arrays.asList("text", "item", "block");
        }
        if (args.length == 2) {
            String action = args[0].toLowerCase(Locale.ROOT);
            if (!Set.of("teleport", "remove", "edit", "copy", "info").contains(action)) {
                return Collections.emptyList();
            }
            return this.plugin.getHologramsManager().getPersistentHolograms().stream().map(hologram -> hologram.getData().getName()).filter(input -> input.toLowerCase().startsWith(args[1].toLowerCase(Locale.ROOT))).toList();
        }
        Hologram hologram2 = this.plugin.getHologramsManager().getHologram(args[1]).orElse(null);
        if (hologram2 == null) {
            return Collections.emptyList();
        }
        HologramType type = hologram2.getData().getType();
        if (args.length == 3) {
            if (!args[0].equalsIgnoreCase("edit")) {
                return Collections.emptyList();
            }
            boolean usingNpcs = PluginUtils.isFancyNpcsEnabled();
            ArrayList<String> suggestions = new ArrayList<String>(Arrays.asList("position", "moveHere", "center", "moveTo", "rotate", "rotatepitch", "billboard", "scale", "translate", "visibilityDistance", "visibility", "shadowRadius", "shadowStrength", "brightness", usingNpcs ? "linkWithNpc" : "", usingNpcs ? "unlinkWithNpc" : ""));
            suggestions.addAll(type.getCommands());
            return suggestions.stream().filter(input -> input.toLowerCase().startsWith(args[2].toLowerCase(Locale.ROOT))).toList();
        }
        if (!args[0].equalsIgnoreCase("edit")) {
            return Collections.emptyList();
        }
        if (args.length == 4) {
            Stream<String> suggestions;
            switch (args[2].toLowerCase(Locale.ROOT)) {
                case "billboard": {
                    ArrayList<Display.Billboard> values = new ArrayList<Display.Billboard>(List.of(Display.Billboard.values()));
                    HologramData hologramData = hologram2.getData();
                    if (hologramData instanceof DisplayHologramData) {
                        DisplayHologramData displayData = (DisplayHologramData)hologramData;
                        values.remove(displayData.getBillboard());
                    }
                    Stream<String> stream = values.stream().map(Enum::name);
                    break;
                }
                case "background": {
                    TextHologramData textData = (TextHologramData)hologram2.getData();
                    ArrayList<Object> colors = new ArrayList<Object>(NamedTextColor.NAMES.keys());
                    colors.add("reset");
                    colors.add("default");
                    colors.add("transparent");
                    Color current = textData.getBackground();
                    if (current == null) {
                        colors.remove("reset");
                        colors.remove("default");
                    } else if (current == Hologram.TRANSPARENT) {
                        colors.remove("transparent");
                    } else {
                        NamedTextColor named = current.getAlpha() == 255 ? NamedTextColor.namedColor((int)current.asRGB()) : null;
                        colors.add(named != null ? named.toString() : "#" + Integer.toHexString(current.asARGB()));
                    }
                    Stream<String> stream = colors.stream();
                    break;
                }
                case "textshadow": {
                    TextHologramData textData = (TextHologramData)hologram2.getData();
                    Stream<String> stream = Stream.of(Boolean.valueOf(!textData.hasTextShadow())).map(Object::toString);
                    break;
                }
                case "brightness": {
                    Stream<String> stream = Stream.of("block", "sky");
                    break;
                }
                case "textalignment": {
                    Stream<String> stream = Arrays.stream(TextDisplay.TextAlignment.values()).map(Enum::name);
                    break;
                }
                case "setline": 
                case "removeline": {
                    TextHologramData textData = (TextHologramData)hologram2.getData();
                    Stream<String> stream = IntStream.range(1, textData.getText().size() + 1).mapToObj(Integer::toString);
                    break;
                }
                case "linkwithnpc": {
                    Stream<String> stream;
                    if (!PluginUtils.isFancyNpcsEnabled()) {
                        stream = Stream.empty();
                        break;
                    }
                    stream = FancyNpcsPlugin.get().getNpcManager().getAllNpcs().stream().map(npc -> npc.getData().getName());
                    break;
                }
                case "block": {
                    Stream<String> stream = Arrays.stream(Material.values()).filter(Material::isBlock).map(Enum::name);
                    break;
                }
                case "seethrough": {
                    Stream<String> stream = Stream.of("true", "false");
                    break;
                }
                case "visibility": {
                    Stream<String> stream = new VisibilityCMD().tabcompletion(sender, hologram2, args).stream();
                    break;
                }
                default: {
                    Stream<String> stream = suggestions = null;
                }
            }
            if (suggestions != null) {
                return suggestions.filter(input -> input.toLowerCase().startsWith(args[3].toLowerCase(Locale.ROOT))).toList();
            }
        }
        if (args[2].equalsIgnoreCase("setline")) {
            TextHologramData textData = (TextHologramData)hologram2.getData();
            Integer index = Ints.tryParse((String)args[3]);
            if (index == null || index < 1 || index > textData.getText().size()) {
                return Collections.emptyList();
            }
            return List.of(textData.getText().get(index - 1));
        }
        if (args[2].equalsIgnoreCase("moveto")) {
            Block target;
            if (!(sender instanceof Player)) {
                return Collections.emptyList();
            }
            Player player = (Player)sender;
            Object suggestions = new ArrayList();
            ((ArrayList)suggestions).add("~");
            ((ArrayList)suggestions).add("~~");
            if (args.length == 7) {
                ((ArrayList)suggestions).add(String.valueOf(player.getLocation().getYaw()));
            }
            if (args.length == 8) {
                ((ArrayList)suggestions).add(String.valueOf(player.getLocation().getPitch()));
            }
            if ((target = player.getTargetBlockExact(10)) != null) {
                Integer coordinate = switch (args.length) {
                    case 4 -> target.getX();
                    case 5 -> target.getY();
                    case 6 -> target.getZ();
                    default -> null;
                };
                ((ArrayList)suggestions).add(String.valueOf(coordinate));
            }
            return suggestions;
        }
        if (args[2].equalsIgnoreCase("brightness")) {
            if (args.length == 4) {
                return List.of("block", "sky");
            }
            if (args.length > 5) {
                return Collections.emptyList();
            }
            return List.of("0", "5", "10", "15");
        }
        return Collections.emptyList();
    }

    private boolean edit(@NotNull CommandSender player, @NotNull Hologram hologram, @NotNull String[] args) {
        String action;
        switch (action = args[2].toLowerCase()) {
            case "position": 
            case "movehere": {
                return new MoveHereCMD().run(player, hologram, args);
            }
            case "center": {
                return new CenterCMD().run(player, hologram, args);
            }
            case "unlinkwithnpc": {
                return new UnlinkWithNpcCMD().run(player, hologram, args);
            }
            case "item": {
                return new ItemCMD().run(player, hologram, args);
            }
        }
        if (args.length == 3) {
            MessageHelper.error(player, "Wrong usage: /hologram help");
            return false;
        }
        return switch (action) {
            case "moveto" -> new MoveToCMD().run(player, hologram, args);
            case "rotate" -> new RotateCMD().run(player, hologram, args);
            case "rotatepitch" -> new RotatePitchCMD().run(player, hologram, args);
            case "billboard" -> new BillboardCMD().run(player, hologram, args);
            case "scale" -> new ScaleCMD().run(player, hologram, args);
            case "translate" -> new TranslateCommand().run(player, hologram, args);
            case "updatetextinterval" -> new UpdateTextIntervalCMD().run(player, hologram, args);
            case "visibilitydistance" -> new VisibilityDistanceCMD().run(player, hologram, args);
            case "visibility" -> new VisibilityCMD().run(player, hologram, args);
            case "linkwithnpc" -> new LinkWithNpcCMD().run(player, hologram, args);
            case "shadowradius" -> new ShadowRadiusCMD().run(player, hologram, args);
            case "shadowstrength" -> new ShadowStrengthCMD().run(player, hologram, args);
            case "brightness" -> new BrightnessCMD().run(player, hologram, args);
            case "background" -> new BackgroundCMD().run(player, hologram, args);
            case "addline" -> new AddLineCMD().run(player, hologram, args);
            case "setline" -> new SetLineCMD().run(player, hologram, args);
            case "removeline" -> new RemoveLineCMD().run(player, hologram, args);
            case "insertbefore" -> new InsertBeforeCMD().run(player, hologram, args);
            case "insertafter" -> new InsertAfterCMD().run(player, hologram, args);
            case "textshadow" -> new TextShadowCMD().run(player, hologram, args);
            case "textalignment" -> new TextAlignmentCMD().run(player, hologram, args);
            case "seethrough" -> new SeeThroughCMD().run(player, hologram, args);
            case "block" -> new BlockCMD().run(player, hologram, args);
            default -> false;
        };
    }
}

