/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.hologram;

import com.fancyinnovations.fancyholograms.api.FancyHolograms;
import com.fancyinnovations.fancyholograms.api.data.BlockHologramData;
import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.data.ItemHologramData;
import com.fancyinnovations.fancyholograms.api.data.TextHologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramDespawnEvent;
import com.fancyinnovations.fancyholograms.api.events.HologramSpawnEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.fancyinnovations.fancyholograms.util.PluginUtils;
import com.viaversion.viaversion.api.Via;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancysitula.api.entities.FS_BlockDisplay;
import de.oliver.fancysitula.api.entities.FS_Display;
import de.oliver.fancysitula.api.entities.FS_ItemDisplay;
import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.api.entities.FS_TextDisplay;
import de.oliver.fancysitula.factories.FancySitula;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public final class HologramImpl
extends Hologram {
    private FS_Display fsDisplay;

    public HologramImpl(@NotNull HologramData data) {
        super(data);
        Location location = data.getLocation();
        if (!location.isWorldLoaded()) {
            return;
        }
        switch (data.getType()) {
            case TEXT: {
                this.fsDisplay = new FS_TextDisplay();
                break;
            }
            case ITEM: {
                this.fsDisplay = new FS_ItemDisplay();
                break;
            }
            case BLOCK: {
                this.fsDisplay = new FS_BlockDisplay();
            }
        }
    }

    @Override
    public void spawnTo(@NotNull Player player) {
        if (!new HologramSpawnEvent((Hologram)this, player).callEvent()) {
            return;
        }
        if (this.fsDisplay == null) {
            return;
        }
        if (!this.data.getWorldName().equals(player.getLocation().getWorld().getName())) {
            return;
        }
        if (FancyHologramsPlugin.get().getFHConfiguration().isHologramsForOldClientsEnabled()) {
            int protocolVersion;
            int n = protocolVersion = PluginUtils.isViaVersionEnabled() ? Via.getAPI().getPlayerVersion(player.getUniqueId()) : 762;
            if (protocolVersion < 762) {
                FancyHolograms.get().getFancyLogger().debug("Player " + player.getName() + " is using an outdated protocol version (" + protocolVersion + "). Hologram will not be shown.", new Property[0]);
                return;
            }
        }
        FS_RealPlayer fsPlayer = new FS_RealPlayer(player);
        FancySitula.ENTITY_FACTORY.spawnEntityFor(fsPlayer, this.fsDisplay);
        this.viewers.add(player.getUniqueId());
        this.updateFor(player);
        this.data.getTraitTrait().onSpawn(player);
    }

    @Override
    public void despawnFrom(@NotNull Player player) {
        if (this.fsDisplay == null) {
            return;
        }
        if (!this.data.getWorldName().equals(player.getLocation().getWorld().getName())) {
            return;
        }
        if (!new HologramDespawnEvent((Hologram)this, player).callEvent()) {
            return;
        }
        FS_RealPlayer fsPlayer = new FS_RealPlayer(player);
        FancySitula.ENTITY_FACTORY.despawnEntityFor(fsPlayer, this.fsDisplay);
        this.viewers.remove(player.getUniqueId());
        this.data.getTraitTrait().onDespawn(player);
    }

    @Override
    public void updateFor(@NotNull Player player) {
        if (this.fsDisplay == null) {
            return;
        }
        if (!this.data.getWorldName().equals(player.getLocation().getWorld().getName())) {
            return;
        }
        this.syncWithData();
        if (!this.isViewer(player)) {
            return;
        }
        FS_RealPlayer fsPlayer = new FS_RealPlayer(player);
        FancySitula.PACKET_FACTORY.createTeleportEntityPacket(this.fsDisplay.getId(), this.data.getLocation().x(), this.data.getLocation().y(), this.data.getLocation().z(), this.data.getLocation().getYaw(), this.data.getLocation().getPitch(), true).send(fsPlayer);
        FS_Display fS_Display = this.fsDisplay;
        if (fS_Display instanceof FS_TextDisplay) {
            FS_TextDisplay textDisplay = (FS_TextDisplay)fS_Display;
            textDisplay.setText(this.getShownText(player));
        }
        FancySitula.ENTITY_FACTORY.setEntityDataFor(fsPlayer, this.fsDisplay);
    }

    /*
     * Unable to fully structure code
     */
    private void syncWithData() {
        block17: {
            block16: {
                if (this.fsDisplay == null) {
                    return;
                }
                location = this.data.getLocation();
                this.fsDisplay.setLocation(location);
                var8_2 = this.fsDisplay;
                if (!(var8_2 instanceof FS_TextDisplay)) break block16;
                textDisplay = (FS_TextDisplay)var8_2;
                var8_2 = this.data;
                if (!(var8_2 instanceof TextHologramData)) break block16;
                textData = (TextHologramData)var8_2;
                textDisplay.setLineWidth(1000);
                background = textData.getBackground();
                if (background == null) {
                    textDisplay.setBackground(0x40000000);
                } else if (background == Hologram.TRANSPARENT) {
                    textDisplay.setBackground(0);
                } else {
                    textDisplay.setBackground(background.asARGB());
                }
                textDisplay.setStyleFlags((byte)0);
                textDisplay.setShadow(textData.hasTextShadow());
                textDisplay.setSeeThrough(textData.isSeeThrough());
                switch (1.$SwitchMap$org$bukkit$entity$TextDisplay$TextAlignment[textData.getTextAlignment().ordinal()]) {
                    case 1: {
                        textDisplay.setAlignLeft(true);
                        break;
                    }
                    case 2: {
                        textDisplay.setAlignRight(true);
                        break;
                    }
                    case 3: {
                        textDisplay.setAlignLeft(false);
                        textDisplay.setAlignRight(false);
                    }
                }
                break block17;
            }
            if (!((var8_2 = this.fsDisplay) instanceof FS_ItemDisplay)) ** GOTO lbl-1000
            itemDisplay = (FS_ItemDisplay)var8_2;
            var8_2 = this.data;
            if (var8_2 instanceof ItemHologramData) {
                itemData = (ItemHologramData)var8_2;
                itemDisplay.setItem(itemData.getItemStack());
            } else if ((var8_2 = this.fsDisplay) instanceof FS_BlockDisplay) {
                blockDisplay = (FS_BlockDisplay)var8_2;
                var8_2 = this.data;
                if (var8_2 instanceof BlockHologramData) {
                    blockData = (BlockHologramData)var8_2;
                    blockDisplay.setBlock(blockData.getBlock().createBlockData().createBlockState());
                }
            }
        }
        var3_4 = this.data;
        if (var3_4 instanceof DisplayHologramData) {
            displayData = (DisplayHologramData)var3_4;
            this.fsDisplay.setTransformationInterpolationDuration(displayData.getInterpolationDuration());
            this.fsDisplay.setTransformationInterpolationStartDeltaTicks(0);
            this.fsDisplay.setBillboard(FS_Display.Billboard.valueOf(displayData.getBillboard().name()));
            if (displayData.getBrightness() != null) {
                this.fsDisplay.setBrightnessOverride(displayData.getBrightness().getBlockLight() << 4 | displayData.getBrightness().getSkyLight() << 20);
            }
            this.fsDisplay.setTranslation(displayData.getTranslation());
            this.fsDisplay.setScale(displayData.getScale());
            this.fsDisplay.setLeftRotation(new Quaternionf());
            this.fsDisplay.setRightRotation(new Quaternionf());
            this.fsDisplay.setShadowRadius(displayData.getShadowRadius());
            this.fsDisplay.setShadowStrength(displayData.getShadowStrength());
            this.fsDisplay.setViewRange(displayData.getVisibilityDistance());
        }
    }
}

