/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.listeners;

import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public final class PlayerListener
implements Listener {
    @NotNull
    private final FancyHologramsPlugin plugin;
    private final Map<UUID, List<UUID>> loadingResourcePacks;

    public PlayerListener(@NotNull FancyHologramsPlugin plugin) {
        this.plugin = plugin;
        this.loadingResourcePacks = new HashMap<UUID, List<UUID>>();
    }

    @NotNull
    private static UUID getResourcePackID(@NotNull PlayerResourcePackStatusEvent event) {
        try {
            event.getClass().getMethod("getID", new Class[0]);
            return event.getID();
        }
        catch (NoSuchMethodException e) {
            return new UUID(0L, 0L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(@NotNull PlayerJoinEvent event) {
        FancyHologramsPlugin.get().getHologramThread().submit(() -> {
            for (Hologram hologram : this.plugin.getRegistry().getAll()) {
                hologram.removeViewer(event.getPlayer().getUniqueId());
                FancyHologramsPlugin.get().getController().refreshHologram(hologram, event.getPlayer());
            }
        });
        if (!this.plugin.getHologramConfiguration().areVersionNotificationsMuted() && event.getPlayer().hasPermission("fancyholograms.admin")) {
            FancyHologramsPlugin.get().getHologramThread().submit(() -> FancyHologramsPlugin.get().getVersionConfig().checkVersionAndDisplay((CommandSender)event.getPlayer(), true));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(@NotNull PlayerQuitEvent event) {
        FancyHologramsPlugin.get().getHologramThread().submit(() -> {
            for (Hologram hologram : this.plugin.getRegistry().getAll()) {
                hologram.removeViewer(event.getPlayer().getUniqueId());
                FancyHologramsPlugin.get().getController().refreshHologram(hologram, event.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTeleport(@NotNull PlayerTeleportEvent event) {
        FancyHologramsPlugin.get().getHologramThread().submit(() -> {
            for (Hologram hologram : this.plugin.getRegistry().getAll()) {
                FancyHologramsPlugin.get().getController().refreshHologram(hologram, event.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(@NotNull PlayerChangedWorldEvent event) {
        FancyHologramsPlugin.get().getHologramThread().submit(() -> {
            for (Hologram hologram : this.plugin.getRegistry().getAll()) {
                hologram.removeViewer(event.getPlayer().getUniqueId());
                FancyHologramsPlugin.get().getController().refreshHologram(hologram, event.getPlayer());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onResourcePackStatus(@NotNull PlayerResourcePackStatusEvent event) {
        if (!event.getPlayer().isOnline()) {
            return;
        }
        UUID playerUniqueId = event.getPlayer().getUniqueId();
        UUID packUniqueId = PlayerListener.getResourcePackID(event);
        if (event.getStatus() == PlayerResourcePackStatusEvent.Status.ACCEPTED) {
            this.loadingResourcePacks.computeIfAbsent(playerUniqueId, ___ -> new ArrayList()).add(packUniqueId);
        } else if (event.getStatus() == PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED || event.getStatus() == PlayerResourcePackStatusEvent.Status.FAILED_DOWNLOAD) {
            this.loadingResourcePacks.computeIfAbsent(playerUniqueId, ___ -> new ArrayList()).removeIf(uuid -> uuid.equals(packUniqueId));
            if (this.loadingResourcePacks.get(playerUniqueId) != null && this.loadingResourcePacks.get(playerUniqueId).isEmpty()) {
                this.loadingResourcePacks.remove(playerUniqueId);
                FancyHologramsPlugin.get().getHologramThread().submit(() -> {
                    for (Hologram hologram : this.plugin.getRegistry().getAll()) {
                        FancyHologramsPlugin.get().getController().refreshHologram(hologram, event.getPlayer());
                    }
                });
            }
        }
    }
}

