/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.config;

import com.fancyinnovations.config.ConfigField;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancyanalytics.logger.properties.ThrowableProperty;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigJSON {
    private final ExtendedFancyLogger logger;
    private final File configFile;
    private final Map<String, ConfigField<?>> fields;
    private final Map<String, Object> values;
    private final Gson gson;

    public ConfigJSON(ExtendedFancyLogger logger, String configFilePath) {
        this.logger = logger;
        this.configFile = new File(configFilePath);
        this.fields = new ConcurrentHashMap();
        this.values = new ConcurrentHashMap<String, Object>();
        this.gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
    }

    public void addField(ConfigField<?> field) {
        this.fields.put(field.path(), field);
    }

    public Map<String, ConfigField<?>> getFields() {
        return this.fields;
    }

    public <T> T get(String path) {
        ConfigField<?> field = this.fields.get(path);
        if (field == null) {
            return null;
        }
        if (field.forceDefault()) {
            return (T)field.defaultValue();
        }
        Object value = this.values.computeIfAbsent(path, k -> field.defaultValue());
        return (T)field.type().cast(value);
    }

    public void reload() {
        JsonObject root;
        if (!this.configFile.exists()) {
            try {
                File parent = this.configFile.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                if (!this.configFile.createNewFile()) {
                    this.logger.error("Failed to create config file: " + this.configFile.getAbsolutePath(), new Property[0]);
                    return;
                }
            }
            catch (IOException e) {
                this.logger.error("Error creating config file: " + this.configFile.getAbsolutePath(), ThrowableProperty.of(e));
                return;
            }
            JsonObject root2 = new JsonObject();
            for (ConfigField<?> field : this.fields.values()) {
                this.setDefault(root2, field);
            }
            this.saveJson(root2);
            return;
        }
        try (FileReader reader = new FileReader(this.configFile);){
            JsonElement parsed = JsonParser.parseReader(reader);
            root = parsed == null || !parsed.isJsonObject() ? new JsonObject() : parsed.getAsJsonObject();
        }
        catch (Exception e) {
            this.logger.error("Error reading config file: " + this.configFile.getAbsolutePath(), ThrowableProperty.of(e));
            root = new JsonObject();
        }
        boolean dirty = false;
        for (Map.Entry<String, ConfigField<?>> entry : this.fields.entrySet()) {
            String path = entry.getKey();
            ConfigField<?> field = entry.getValue();
            if (field.forRemoval()) {
                if (!this.isSet(root, path)) continue;
                this.logger.debug("Removing path '" + path + "' from config", new Property[0]);
                this.removePath(root, path);
                dirty = true;
                continue;
            }
            JsonElement elem = this.getElement(root, path);
            if (elem != null && !elem.isJsonNull()) {
                try {
                    Object deserialized = this.gson.fromJson(elem, (Type)field.type());
                    if (deserialized != null && field.type().isInstance(deserialized)) {
                        this.values.put(path, deserialized);
                        continue;
                    }
                    Object converted = this.tryConvertNumber(deserialized, field.type());
                    if (converted != null) {
                        this.values.put(path, converted);
                        continue;
                    }
                    this.logger.warn("Value for path '" + path + "' is not of type '" + field.type().getSimpleName() + "'", new Property[0]);
                    this.setDefault(root, field);
                    dirty = true;
                }
                catch (JsonSyntaxException | ClassCastException ex) {
                    this.logger.warn("Failed to parse value for path '" + path + "': " + ex.getMessage(), new Property[0]);
                    this.setDefault(root, field);
                    dirty = true;
                }
                continue;
            }
            this.logger.debug("Path '" + path + "' not found in config", new Property[0]);
            this.setDefault(root, field);
            dirty = true;
        }
        if (dirty) {
            this.saveJson(root);
        }
    }

    private void setDefault(JsonObject root, ConfigField<?> field) {
        this.logger.debug("Setting default value for path '" + field.path() + "': " + String.valueOf(field.defaultValue()), new Property[0]);
        JsonElement elem = this.gson.toJsonTree(field.defaultValue(), field.type());
        this.setElement(root, field.path(), elem);
    }

    private void saveJson(JsonObject root) {
        try (FileWriter writer = new FileWriter(this.configFile);){
            this.gson.toJson((JsonElement)root, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.error("Error saving config file: " + this.configFile.getAbsolutePath(), ThrowableProperty.of(e));
        }
    }

    private JsonElement getElement(JsonObject root, String path) {
        String[] parts = path.split("\\.");
        JsonElement current = root;
        for (String p : parts) {
            if (!current.isJsonObject()) {
                return null;
            }
            JsonObject obj = current.getAsJsonObject();
            if (!obj.has(p)) {
                return null;
            }
            current = obj.get(p);
        }
        return current;
    }

    private void setElement(JsonObject root, String path, JsonElement value) {
        String[] parts = path.split("\\.");
        JsonObject current = root;
        for (int i = 0; i < parts.length - 1; ++i) {
            String p = parts[i];
            if (!current.has(p) || !current.get(p).isJsonObject()) {
                JsonObject child = new JsonObject();
                current.add(p, child);
                current = child;
                continue;
            }
            current = current.getAsJsonObject(p);
        }
        current.add(parts[parts.length - 1], value);
    }

    private boolean isSet(JsonObject root, String path) {
        return this.getElement(root, path) != null;
    }

    private void removePath(JsonObject root, String path) {
        String[] parts = path.split("\\.");
        JsonObject current = root;
        for (int i = 0; i < parts.length - 1; ++i) {
            String p = parts[i];
            if (!current.has(p) || !current.get(p).isJsonObject()) {
                return;
            }
            current = current.getAsJsonObject(p);
        }
        current.remove(parts[parts.length - 1]);
    }

    private Object tryConvertNumber(Object value, Class<?> target) {
        if (!(value instanceof Number)) {
            return null;
        }
        Number num = (Number)value;
        if (target == Integer.class || target == Integer.TYPE) {
            return num.intValue();
        }
        if (target == Long.class || target == Long.TYPE) {
            return num.longValue();
        }
        if (target == Double.class || target == Double.TYPE) {
            return num.doubleValue();
        }
        if (target == Float.class || target == Float.TYPE) {
            return Float.valueOf(num.floatValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            return num.shortValue();
        }
        if (target == Byte.class || target == Byte.TYPE) {
            return num.byteValue();
        }
        return null;
    }
}

