/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.api;

import com.fancyinnovations.fancyholograms.api.HologramConfiguration;
import com.fancyinnovations.fancyholograms.api.HologramController;
import com.fancyinnovations.fancyholograms.api.HologramRegistry;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitRegistry;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;

public interface FancyHolograms {
    public static FancyHolograms get() {
        if (FancyHolograms.isEnabled()) {
            return EnabledChecker.getPlugin();
        }
        throw new NullPointerException("Plugin is not enabled");
    }

    public static boolean isEnabled() {
        return EnabledChecker.isFancyHologramsEnabled();
    }

    public JavaPlugin getPlugin();

    public ExtendedFancyLogger getFancyLogger();

    public HologramConfiguration getHologramConfiguration();

    @ApiStatus.Internal
    public Function<HologramData, Hologram> getHologramFactory();

    public ScheduledExecutorService getHologramThread();

    public HologramRegistry getRegistry();

    public HologramController getController();

    @ApiStatus.Experimental
    public HologramTraitRegistry getTraitRegistry();

    public static class EnabledChecker {
        private static Boolean enabled;
        private static FancyHolograms plugin;

        public static Boolean isFancyHologramsEnabled() {
            if (enabled != null) {
                return enabled;
            }
            Plugin pl = Bukkit.getPluginManager().getPlugin("FancyHolograms");
            if (pl != null && pl.isEnabled()) {
                try {
                    plugin = (FancyHolograms)pl;
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("API failed to access plugin, if using the FancyHolograms API make sure to set the dependency to compile only.");
                }
                enabled = true;
                return true;
            }
            return false;
        }

        public static FancyHolograms getPlugin() {
            return plugin;
        }
    }
}

