/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands;

import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.converter.ConverterTarget;
import com.fancyinnovations.fancyholograms.converter.FHConversionRegistry;
import com.fancyinnovations.fancyholograms.converter.HologramConversionSession;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import de.oliver.fancylib.MessageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class FancyHologramsCMD
extends Command {
    public static final String FH_COMMAND_USAGE = "/fancyholograms <save|reload|version|convert>";
    @NotNull
    private final FancyHologramsPlugin plugin;

    public FancyHologramsCMD(@NotNull FancyHologramsPlugin plugin) {
        super("fancyholograms");
        this.setPermission("fancyholograms.admin");
        this.plugin = plugin;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (args.length < 1) {
            MessageHelper.info(sender, FH_COMMAND_USAGE);
            return false;
        }
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "save": {
                this.plugin.savePersistentHolograms();
                MessageHelper.success(sender, "Saved all holograms");
                break;
            }
            case "reload": {
                this.plugin.getFHConfiguration().reload();
                ArrayList<Hologram> allHolograms = new ArrayList<Hologram>(this.plugin.getRegistry().getAll());
                this.plugin.getRegistry().clear();
                for (Hologram hologram : allHolograms) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        hologram.despawnFrom(player);
                    }
                    for (UUID viewer : hologram.getViewers()) {
                        hologram.removeViewer(viewer);
                    }
                }
                Collection<HologramData> hologramData = this.plugin.getStorage().loadAll();
                for (HologramData data : hologramData) {
                    Hologram hologram = this.plugin.getHologramFactory().apply(data);
                    this.plugin.getRegistry().register(hologram);
                }
                MessageHelper.success(sender, "Reloaded config and holograms");
                break;
            }
            case "version": {
                FancyHologramsPlugin.get().getHologramThread().submit(() -> FancyHologramsPlugin.get().getVersionConfig().checkVersionAndDisplay(sender, false));
                break;
            }
            case "convert": {
                if (args.length < 3) {
                    MessageHelper.info(sender, "Usage: /fancyholograms convert <type> <targets> [args...]");
                    return false;
                }
                String converterId = args[1];
                FHConversionRegistry.getConverterById(converterId).ifPresentOrElse(converter -> {
                    String[] converterArgs = (String[])Arrays.asList(args).subList(2, args.length).toArray(String[]::new);
                    ConverterTarget target = ConverterTarget.ofStringNullable(args[2]);
                    if (target == null) {
                        MessageHelper.error(sender, "Invalid regex for your conversion target!");
                        return;
                    }
                    HologramConversionSession session = new HologramConversionSession(target, sender, converterArgs);
                    try {
                        List<HologramData> holograms = converter.convert(session);
                        for (HologramData data : holograms) {
                            Hologram hologram = this.plugin.getHologramFactory().apply(data);
                            this.plugin.getRegistry().register(hologram);
                        }
                        this.plugin.savePersistentHolograms();
                        MessageHelper.success(sender, String.format("Converted successfully, produced %s total holograms!", holograms.size()));
                    }
                    catch (Exception error) {
                        MessageHelper.error(sender, error.getMessage());
                    }
                }, () -> MessageHelper.error(sender, "That converter is not registered. Look at the developer documentation if you are adding converters."));
                break;
            }
            default: {
                MessageHelper.info(sender, FH_COMMAND_USAGE);
                return false;
            }
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) throws IllegalArgumentException {
        if (args.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            suggestions.addAll(Arrays.asList("version", "reload", "save", "convert"));
        } else if (Objects.equals(args[0], "convert")) {
            if (args.length == 2) {
                suggestions.addAll(FHConversionRegistry.getAllUsableConverterIds());
            } else if (args.length == 3) {
                String converterId = args[1];
                FHConversionRegistry.getConverterById(converterId).ifPresent(converter -> {
                    suggestions.addAll(converter.getConvertableHolograms());
                    suggestions.add("*");
                });
            }
        }
        String lastArgument = args[args.length - 1];
        return suggestions.stream().filter(alias -> alias.startsWith(lastArgument.toLowerCase(Locale.ROOT))).toList();
    }
}

