/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.commands.hologram;

import com.fancyinnovations.fancyholograms.api.data.DisplayHologramData;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.events.HologramUpdateEvent;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.Subcommand;
import com.fancyinnovations.fancyholograms.main.FancyHologramsPlugin;
import com.google.common.base.Enums;
import de.oliver.fancylib.MessageHelper;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BillboardCMD
implements Subcommand {
    @Override
    public List<String> tabcompletion(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        return null;
    }

    @Override
    public boolean run(@NotNull CommandSender player, @Nullable Hologram hologram, @NotNull String[] args) {
        if (!player.hasPermission("fancyholograms.hologram.edit.billboard")) {
            MessageHelper.error(player, "You don't have the required permission to change the billboard of a hologram");
            return false;
        }
        Display.Billboard billboard = (Display.Billboard)Enums.getIfPresent(Display.Billboard.class, (String)args[3].toUpperCase(Locale.ROOT)).orNull();
        if (billboard == null) {
            MessageHelper.error(player, "Could not parse billboard");
            return false;
        }
        HologramData hologramData = hologram.getData();
        if (!(hologramData instanceof DisplayHologramData)) {
            MessageHelper.error(player, "This command can only be used on display holograms");
            return false;
        }
        DisplayHologramData displayData = (DisplayHologramData)hologramData;
        if (billboard == displayData.getBillboard()) {
            MessageHelper.warning(player, "This billboard is already set");
            return false;
        }
        DisplayHologramData copied = displayData.copy(displayData.getName());
        copied.setBillboard(billboard);
        if (!HologramCMD.callModificationEvent(hologram, player, copied, HologramUpdateEvent.HologramModification.BILLBOARD)) {
            return false;
        }
        if (copied.getBillboard() == displayData.getBillboard()) {
            MessageHelper.warning(player, "This billboard is already set");
            return false;
        }
        displayData.setBillboard(copied.getBillboard());
        if (FancyHologramsPlugin.get().getHologramConfiguration().isSaveOnChangedEnabled()) {
            FancyHologramsPlugin.get().getStorage().save(hologram.getData());
        }
        MessageHelper.success(player, "Changed the billboard to " + StringUtils.capitalize((String)billboard.name().toLowerCase(Locale.ROOT)));
        return true;
    }
}

