/*
 * Decompiled with CFR 0.152.
 */
package com.fancyinnovations.fancyholograms.main;

import com.fancyinnovations.fancyholograms.api.FancyHolograms;
import com.fancyinnovations.fancyholograms.api.HologramConfiguration;
import com.fancyinnovations.fancyholograms.api.HologramController;
import com.fancyinnovations.fancyholograms.api.HologramRegistry;
import com.fancyinnovations.fancyholograms.api.data.HologramData;
import com.fancyinnovations.fancyholograms.api.hologram.Hologram;
import com.fancyinnovations.fancyholograms.api.trait.HologramTraitRegistry;
import com.fancyinnovations.fancyholograms.commands.FancyHologramsCMD;
import com.fancyinnovations.fancyholograms.commands.HologramCMD;
import com.fancyinnovations.fancyholograms.commands.lampCommands.fancyholograms.ConfigCMD;
import com.fancyinnovations.fancyholograms.commands.lampCommands.hologram.TraitCMD;
import com.fancyinnovations.fancyholograms.commands.lampCommands.types.HologramCommandType;
import com.fancyinnovations.fancyholograms.commands.lampCommands.types.TraitCommandType;
import com.fancyinnovations.fancyholograms.config.FHConfiguration;
import com.fancyinnovations.fancyholograms.controller.HologramControllerImpl;
import com.fancyinnovations.fancyholograms.converter.FHConversionRegistry;
import com.fancyinnovations.fancyholograms.hologram.HologramImpl;
import com.fancyinnovations.fancyholograms.listeners.BedrockPlayerListener;
import com.fancyinnovations.fancyholograms.listeners.NpcListener;
import com.fancyinnovations.fancyholograms.listeners.PlayerListener;
import com.fancyinnovations.fancyholograms.listeners.PlayerLoadedListener;
import com.fancyinnovations.fancyholograms.listeners.WorldLoadedListener;
import com.fancyinnovations.fancyholograms.metrics.FHMetrics;
import com.fancyinnovations.fancyholograms.registry.HologramRegistryImpl;
import com.fancyinnovations.fancyholograms.storage.HologramStorage;
import com.fancyinnovations.fancyholograms.storage.StorageMigrator;
import com.fancyinnovations.fancyholograms.storage.json.JsonStorage;
import com.fancyinnovations.fancyholograms.trait.HologramTraitRegistryImpl;
import com.fancyinnovations.fancyholograms.trait.builtin.DebugTrait;
import com.fancyinnovations.fancyholograms.trait.builtin.FileContentTrait;
import com.fancyinnovations.fancyholograms.trait.builtin.InteractionTrait;
import com.fancyinnovations.fancyholograms.trait.builtin.MultiplePagesTrait;
import com.fancyinnovations.fancyholograms.util.PluginUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.oliver.fancyanalytics.logger.ExtendedFancyLogger;
import de.oliver.fancyanalytics.logger.LogLevel;
import de.oliver.fancyanalytics.logger.appender.ConsoleAppender;
import de.oliver.fancyanalytics.logger.appender.JsonAppender;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancylib.FancyLib;
import de.oliver.fancylib.VersionConfig;
import de.oliver.fancylib.logging.PluginMiddleware;
import de.oliver.fancylib.serverSoftware.ServerSoftware;
import de.oliver.fancylib.translations.Language;
import de.oliver.fancylib.translations.TextConfig;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancylib.versionFetcher.MasterVersionFetcher;
import de.oliver.fancylib.versionFetcher.VersionFetcher;
import de.oliver.fancysitula.api.IFancySitula;
import de.oliver.fancysitula.api.utils.ServerVersion;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.BukkitLamp;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;

public final class FancyHologramsPlugin
extends JavaPlugin
implements FancyHolograms {
    @Nullable
    private static FancyHologramsPlugin INSTANCE;
    private final ExtendedFancyLogger fancyLogger;
    private final FHMetrics metrics;
    private final VersionFetcher versionFetcher;
    private final VersionConfig versionConfig;
    private final ScheduledExecutorService hologramThread;
    private final ExecutorService storageThread;
    private final FHConfiguration configuration;
    private final Translator translator;
    private Function<HologramData, Hologram> hologramFactory;
    private HologramStorage storage;
    private HologramRegistryImpl registry;
    private HologramControllerImpl controller;
    private HologramTraitRegistryImpl traitRegistry;

    public FancyHologramsPlugin() {
        INSTANCE = this;
        ConsoleAppender consoleAppender = new ConsoleAppender("[{loggerName}] ({threadName}) {logLevel}: {message}");
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
        File logsFile = new File("plugins/FancyHolograms/logs/FH-logs-" + date + ".txt");
        if (!logsFile.exists()) {
            try {
                logsFile.getParentFile().mkdirs();
                logsFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JsonAppender jsonAppender = new JsonAppender(false, false, true, logsFile.getPath());
        this.fancyLogger = new ExtendedFancyLogger("FancyHolograms", LogLevel.INFO, List.of(consoleAppender, jsonAppender), List.of(new PluginMiddleware((Plugin)this)));
        this.versionFetcher = new MasterVersionFetcher("FancyHolograms");
        this.versionConfig = new VersionConfig((Plugin)this, this.versionFetcher);
        this.metrics = new FHMetrics();
        this.hologramThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("FancyHolograms-Hologram").build());
        this.storageThread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setPriority(2).setNameFormat("FancyHolograms-Storage").build());
        this.configuration = new FHConfiguration();
        this.translator = new Translator(new TextConfig("#32e347", "#35ad1d", "#81E366", "#E3CA66", "#E36666", ""));
    }

    @NotNull
    public static FancyHologramsPlugin get() {
        return Objects.requireNonNull(INSTANCE, "plugin is not initialized");
    }

    public static boolean canGet() {
        return INSTANCE != null;
    }

    public void onLoad() {
        LogLevel logLevel;
        this.configuration.init();
        try {
            logLevel = LogLevel.valueOf(this.configuration.getLogLevel());
        }
        catch (IllegalArgumentException e) {
            logLevel = LogLevel.INFO;
        }
        this.fancyLogger.setCurrentLevel(logLevel);
        IFancySitula.LOGGER.setCurrentLevel(logLevel);
        this.storage = new JsonStorage();
        this.registry = new HologramRegistryImpl();
        this.controller = new HologramControllerImpl();
        this.traitRegistry = new HologramTraitRegistryImpl();
        if (!ServerSoftware.isPaper()) {
            this.fancyLogger.warn("--------------------------------------------------\nIt is recommended to use Paper as server software.\nBecause you are not using paper, the plugin\nmight not work correctly.\n--------------------------------------------------\n", new Property[0]);
        }
        if (!ServerVersion.isVersionSupported(Bukkit.getMinecraftVersion())) {
            this.fancyLogger.warn("--------------------------------------------------\nUnsupported minecraft server version.\nPlease update the server to one of (%s).\nDisabling the FancyHolograms plugin.\n--------------------------------------------------\n".formatted(String.join((CharSequence)" / ", ServerVersion.getSupportedVersions())), new Property[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.hologramFactory = HologramImpl::new;
        this.translator.loadLanguages(this.getDataFolder().getAbsolutePath());
        Language selectedLanguage = this.translator.getLanguages().stream().filter(language -> language.getLanguageName().equals(this.configuration.getLanguage())).findFirst().orElse(this.translator.getFallbackLanguage());
        this.translator.setSelectedLanguage(selectedLanguage);
        this.fancyLogger.info("Successfully loaded FancyHolograms version %s".formatted(this.getDescription().getVersion()), new Property[0]);
    }

    public void onEnable() {
        new FancyLib(INSTANCE);
        this.registerCommands();
        if (this.configuration.useLampCommands()) {
            this.registerLampCommands();
        }
        this.registerListeners();
        this.versionConfig.load();
        if (!this.configuration.areVersionNotificationsMuted()) {
            this.checkForNewerVersion();
        }
        if (this.versionConfig.isDevelopmentBuild()) {
            this.fancyLogger.warn("\n--------------------------------------------------\nYou are using a development build of FancyHolograms.\nPlease be aware that there might be bugs in this version.\nIf you find any bugs, please report them on our discord server (https://discord.gg/ZUgYCEJUEx).\nRead more about the risks of using a development build here: https://docs.fancyinnovations.com/development-guidelines/versioning/#build\n--------------------------------------------------\n", new Property[0]);
        }
        this.metrics.register();
        this.metrics.registerLegacy();
        this.metrics.checkIfPluginVersionUpdated();
        this.traitRegistry.register(DebugTrait.class);
        this.traitRegistry.register(MultiplePagesTrait.class);
        this.traitRegistry.register(FileContentTrait.class);
        this.traitRegistry.register(InteractionTrait.class);
        new StorageMigrator().migrate();
        Collection<HologramData> data = this.storage.loadAll();
        for (HologramData d : data) {
            Hologram hologram = this.hologramFactory.apply(d);
            this.registry.register(hologram);
        }
        this.controller.initRefreshTask();
        this.controller.initUpdateTask();
        if (this.configuration.isAutosaveEnabled()) {
            this.getHologramThread().scheduleWithFixedDelay(this::savePersistentHolograms, this.configuration.getAutosaveInterval(), 120L, TimeUnit.SECONDS);
        }
        FHConversionRegistry.registerBuiltInConverters();
        this.fancyLogger.info("Successfully enabled FancyHolograms version %s".formatted(this.getDescription().getVersion()), new Property[0]);
    }

    public void onDisable() {
        this.savePersistentHolograms();
        this.hologramThread.shutdown();
        this.storageThread.shutdown();
        this.fancyLogger.info("Successfully disabled FancyHolograms version %s".formatted(this.getDescription().getVersion()), new Property[0]);
        INSTANCE = null;
    }

    private void registerCommands() {
        List<Command> commands = Arrays.asList(new Command[]{new HologramCMD(this), new FancyHologramsCMD(this)});
        if (this.configuration.isRegisterCommands()) {
            commands.forEach(command -> this.getServer().getCommandMap().register("fancyholograms", command));
        } else {
            commands.stream().filter(Command::isRegistered).forEach(command -> command.unregister(this.getServer().getCommandMap()));
        }
    }

    private void registerLampCommands() {
        Lamp.Builder<BukkitCommandActor> lampBuilder = BukkitLamp.builder(this);
        lampBuilder.parameterTypes(builder -> {
            builder.addParameterType(Hologram.class, HologramCommandType.INSTANCE);
            builder.addParameterType(HologramTraitRegistry.TraitInfo.class, TraitCommandType.INSTANCE);
        });
        lampBuilder.exceptionHandler(HologramCommandType.INSTANCE).exceptionHandler(TraitCommandType.INSTANCE);
        Lamp<BukkitCommandActor> lamp = lampBuilder.build();
        lamp.register(ConfigCMD.INSTANCE);
        lamp.register(TraitCMD.INSTANCE);
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldLoadedListener(), (Plugin)this);
        if (Bukkit.getMinecraftVersion().equals("1.21.4") || Bukkit.getMinecraftVersion().equals("1.21.5") || Bukkit.getMinecraftVersion().equals("1.21.6")) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerLoadedListener(), (Plugin)this);
        }
        if (PluginUtils.isFancyNpcsEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new NpcListener(this), (Plugin)this);
        }
        if (this.configuration.isHologramsForBedrockPlayersEnabled() && PluginUtils.isFloodgateEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new BedrockPlayerListener(), (Plugin)this);
        }
    }

    private void checkForNewerVersion() {
        ComparableVersion current = new ComparableVersion(this.versionConfig.getVersion());
        ((CompletableFuture)CompletableFuture.supplyAsync(this.getVersionFetcher()::fetchNewestVersion).thenApply(Objects::requireNonNull)).whenComplete((newest, error) -> {
            if (error != null || newest.compareTo(current) <= 0) {
                return;
            }
            this.fancyLogger.warn("\n-------------------------------------------------------\nYou are not using the latest version of the FancyHolograms plugin.\nPlease update to the newest version (%s).\n%s\n-------------------------------------------------------\n".formatted(newest, this.getVersionFetcher().getDownloadUrl()), new Property[0]);
        });
    }

    public void savePersistentHolograms() {
        List<HologramData> toSave = this.registry.getAllPersistent().stream().map(Hologram::getData).toList();
        this.storage.saveBatch(toSave);
    }

    @Override
    public JavaPlugin getPlugin() {
        return INSTANCE;
    }

    @Override
    public ExtendedFancyLogger getFancyLogger() {
        return this.fancyLogger;
    }

    public FHMetrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    public VersionFetcher getVersionFetcher() {
        return this.versionFetcher;
    }

    @NotNull
    public VersionConfig getVersionConfig() {
        return this.versionConfig;
    }

    @Override
    public HologramController getController() {
        return this.controller;
    }

    public HologramControllerImpl getControllerImpl() {
        return this.controller;
    }

    @Override
    public HologramRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public HologramTraitRegistryImpl getTraitRegistry() {
        return this.traitRegistry;
    }

    @Override
    public HologramConfiguration getHologramConfiguration() {
        return this.configuration;
    }

    @Override
    public Function<HologramData, Hologram> getHologramFactory() {
        return this.hologramFactory;
    }

    public HologramStorage getStorage() {
        return this.storage;
    }

    @Override
    public ScheduledExecutorService getHologramThread() {
        return this.hologramThread;
    }

    public ExecutorService getStorageThread() {
        return this.storageThread;
    }

    public FHConfiguration getFHConfiguration() {
        return this.configuration;
    }

    public Translator getTranslator() {
        return this.translator;
    }
}

