/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.plugintests;

public class Expectable<T> {
    private final T t;

    private Expectable(T t) {
        this.t = t;
    }

    public static <T> Expectable<T> expect(T t) {
        return new Expectable<T>(t);
    }

    public void toBeDefined() {
        if (this.t == null) {
            throw new AssertionError((Object)"Expected not null but got null");
        }
    }

    public void toBeNull() {
        if (this.t != null) {
            throw new AssertionError((Object)"Expected null but got not null");
        }
    }

    public void toBe(T expected) {
        if (this.t != expected) {
            throw new AssertionError((Object)("Expected " + String.valueOf(expected) + " but got " + String.valueOf(this.t)));
        }
    }

    public void toEqual(T expected) {
        if (!this.t.equals(expected)) {
            throw new AssertionError((Object)("Expected " + String.valueOf(expected) + " but got " + String.valueOf(this.t)));
        }
    }

    public void toBeGreaterThan(T expected) {
        if (this.t instanceof Integer) {
            if ((Integer)this.t <= (Integer)expected) {
                throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be greater than " + String.valueOf(expected)));
            }
            return;
        }
        if (this.t instanceof Long) {
            if ((Long)this.t <= (Long)expected) {
                throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be greater than " + String.valueOf(expected)));
            }
            return;
        }
        if (this.t instanceof Float) {
            if (((Float)this.t).floatValue() <= ((Float)expected).floatValue()) {
                throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be greater than " + String.valueOf(expected)));
            }
            return;
        }
        if (this.t instanceof Double) {
            if ((Double)this.t <= (Double)expected) {
                throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be greater than " + String.valueOf(expected)));
            }
            return;
        }
        throw new AssertionError((Object)"toBeGreaterThan can only be used on Integers, Longs, Floats, and Doubles");
    }

    public void toBeLessThan(T expected) {
        if (this.t instanceof Integer) {
            if ((Integer)this.t >= (Integer)expected) {
                throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be less than " + String.valueOf(expected)));
            }
            return;
        }
        if (this.t instanceof Long) {
            if ((Long)this.t >= (Long)expected) {
                throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be less than " + String.valueOf(expected)));
            }
            return;
        }
        if (this.t instanceof Float) {
            if (((Float)this.t).floatValue() >= ((Float)expected).floatValue()) {
                throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be less than " + String.valueOf(expected)));
            }
            return;
        }
        if (this.t instanceof Double) {
            if ((Double)this.t >= (Double)expected) {
                throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be less than " + String.valueOf(expected)));
            }
            return;
        }
        throw new AssertionError((Object)"toBeLessThan can only be used on Integers, Longs, Floats, and Doubles");
    }

    public void toBeInstanceOf(Class<?> expected) {
        if (!expected.isInstance(this.t)) {
            throw new AssertionError((Object)("Expected " + String.valueOf(this.t) + " to be an instance of " + String.valueOf(expected)));
        }
    }

    public void toContain(Object expected) {
        if (this.t instanceof String) {
            if (!((String)this.t).contains((String)expected)) {
                throw new AssertionError((Object)("Expected " + String.valueOf(expected) + " to be contained in " + String.valueOf(this.t)));
            }
            return;
        }
        if (this.t instanceof Iterable) {
            if (!((Iterable)this.t).spliterator().tryAdvance(o -> {
                if (o.equals(expected)) {
                    return;
                }
                throw new AssertionError((Object)("Expected " + String.valueOf(expected) + " to be contained in " + String.valueOf(this.t)));
            })) {
                throw new AssertionError((Object)("Expected " + String.valueOf(expected) + " to be contained in " + String.valueOf(this.t)));
            }
            return;
        }
        if (this.t instanceof Object[]) {
            for (Object o2 : (Object[])this.t) {
                if (!o2.equals(expected)) continue;
                return;
            }
            throw new AssertionError((Object)("Expected " + String.valueOf(expected) + " to be contained in " + String.valueOf(this.t)));
        }
        throw new AssertionError((Object)"toContain can only be used on Strings, Iterables and Arrays");
    }

    public void toHaveLength(int expected) {
        if (this.t instanceof String) {
            if (((String)this.t).length() != expected) {
                throw new AssertionError((Object)("Expected " + expected + " but got " + ((String)this.t).length()));
            }
            return;
        }
        if (this.t instanceof Iterable) {
            if (((Iterable)this.t).spliterator().getExactSizeIfKnown() != (long)expected) {
                throw new AssertionError((Object)("Expected " + expected + " but got " + ((Iterable)this.t).spliterator().getExactSizeIfKnown()));
            }
            return;
        }
        if (this.t instanceof Object[]) {
            if (((Object[])this.t).length != expected) {
                throw new AssertionError((Object)("Expected " + expected + " but got " + ((Object[])this.t).length));
            }
            return;
        }
        throw new AssertionError((Object)"toHaveLength can only be used on Strings");
    }

    public <E extends Throwable> E toThrow(Class<E> expected) {
        try {
            ((Runnable)this.t).run();
        }
        catch (Throwable e) {
            if (expected.isInstance(e)) {
                return (E)e;
            }
            throw new AssertionError((Object)("Expected " + expected.getSimpleName() + " but got " + e.getClass().getSimpleName()));
        }
        throw new AssertionError((Object)("Expected " + expected.getSimpleName() + " but got nothing"));
    }
}

