/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining.block.custom;

import com.baisylia.modestmining.block.ModBlocks;
import com.baisylia.modestmining.block.entity.ModBlockEntities;
import com.baisylia.modestmining.block.entity.custom.BrushingBlockEntity;
import com.baisylia.modestmining.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrushingBlock
extends BaseEntityBlock {
    public static IntegerProperty BRUSHING = IntegerProperty.m_61631_((String)"brushing", (int)0, (int)3);
    private static final VoxelShape[] SHAPE_BY_BRUSH = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public BrushingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)BRUSHING, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_BRUSH[(Integer)state.m_61143_((Property)BRUSHING)];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BRUSHING});
        super.m_7926_(builder);
    }

    public int getMaxBrushingStage() {
        return 3;
    }

    protected void m_142387_(Level p_152422_, Player p_152423_, BlockPos p_152424_, BlockState p_152425_) {
        p_152422_.m_5898_(p_152423_, 2001, p_152424_, BrushingBlock.m_49956_((BlockState)p_152425_));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(handIn);
        ItemStack offhandStack = player.m_21206_();
        if (!worldIn.m_5776_()) {
            BlockEntity entity = worldIn.m_7702_(pos);
            if (entity instanceof BrushingBlockEntity) {
                if (worldIn.m_8055_(pos).m_60734_() != ModBlocks.SUSPICIOUS_STONE.get()) {
                    if (handIn.equals((Object)InteractionHand.MAIN_HAND) && heldStack.m_150930_((Item)ModItems.BRUSH.get())) {
                        this.brushAtBlock(state, worldIn, pos, player, handIn, hit, entity, heldStack, 4);
                    } else if (handIn.equals((Object)InteractionHand.OFF_HAND) && offhandStack.m_150930_((Item)ModItems.BRUSH.get())) {
                        this.brushAtBlock(state, worldIn, pos, player, handIn, hit, entity, offhandStack, 4);
                    }
                } else if (handIn.equals((Object)InteractionHand.MAIN_HAND) && heldStack.m_150930_((Item)ModItems.CHISEL.get())) {
                    this.brushAtBlock(state, worldIn, pos, player, handIn, hit, entity, heldStack, 4);
                } else if (handIn.equals((Object)InteractionHand.OFF_HAND) && offhandStack.m_150930_((Item)ModItems.CHISEL.get())) {
                    this.brushAtBlock(state, worldIn, pos, player, handIn, hit, entity, offhandStack, 4);
                }
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.PASS;
    }

    protected void brushAtBlock(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, BlockEntity entity, ItemStack itemStack, int inProgress) {
        ((BrushingBlockEntity)entity).canProgress = true;
        ((BrushingBlockEntity)entity).playerProgress += inProgress;
        if (((BrushingBlockEntity)entity).playerProgress > ((BrushingBlockEntity)entity).maxProgress / 4 * 3) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BRUSHING, (Comparable)Integer.valueOf(3)), 2);
        } else if (((BrushingBlockEntity)entity).playerProgress > ((BrushingBlockEntity)entity).maxProgress / 2) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BRUSHING, (Comparable)Integer.valueOf(2)), 2);
        } else if (((BrushingBlockEntity)entity).playerProgress > ((BrushingBlockEntity)entity).maxProgress / 4) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BRUSHING, (Comparable)Integer.valueOf(1)), 2);
        }
        if (worldIn.m_8055_(pos).m_60734_() != ModBlocks.SUSPICIOUS_STONE.get()) {
            worldIn.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11988_, SoundSource.BLOCKS, 0.25f, 0.5f);
        } else {
            worldIn.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12442_, SoundSource.BLOCKS, 0.25f, 0.5f);
        }
        this.m_142387_(worldIn, player, pos, state);
        if (!player.m_7500_()) {
            itemStack.m_41721_(itemStack.m_41773_() + 1);
            if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                itemStack.m_41774_(1);
            }
        }
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new BrushingBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BrushingBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.BRUSHING_BLOCK_ENTITY.get()), BrushingBlockEntity::tick);
    }
}

