/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining.block.entity.custom;

import com.baisylia.modestmining.block.ModBlocks;
import com.baisylia.modestmining.block.custom.BrushingBlock;
import com.baisylia.modestmining.block.entity.ModBlockEntities;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BrushingBlockEntity
extends BlockEntity {
    public int playerProgress = 0;
    public int brushProgress = 0;
    public int maxProgress = 120;
    public boolean canProgress = false;

    public BrushingBlockEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ModBlockEntities.BRUSHING_BLOCK_ENTITY.get(), pPos, pState);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
    }

    @Nullable
    @Nonnull
    public static void tick(Level worldIn, BlockPos pos, BlockState state, BrushingBlockEntity pBlockEntity) {
        Random random = new Random();
        if (pBlockEntity.canProgress && pBlockEntity.brushProgress < pBlockEntity.maxProgress) {
            ++pBlockEntity.brushProgress;
            if (pBlockEntity.playerProgress - 16 > pBlockEntity.brushProgress) {
                pBlockEntity.canProgress = false;
                pBlockEntity.brushProgress = 0;
                pBlockEntity.playerProgress = 0;
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BrushingBlock.BRUSHING, (Comparable)Integer.valueOf(0)), 3);
            }
            if (pBlockEntity.playerProgress + 8 < pBlockEntity.brushProgress) {
                pBlockEntity.canProgress = false;
                pBlockEntity.brushProgress = 0;
                pBlockEntity.playerProgress = 0;
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BrushingBlock.BRUSHING, (Comparable)Integer.valueOf(0)), 3);
            }
        }
        if (pBlockEntity.brushProgress >= pBlockEntity.maxProgress) {
            Block.m_49950_((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.m_7471_(pos, true);
            if (worldIn.m_8055_(pos).m_60734_() != ModBlocks.SUSPICIOUS_STONE.get()) {
                worldIn.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11988_, SoundSource.BLOCKS, 0.25f, 0.5f);
            } else {
                worldIn.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12442_, SoundSource.BLOCKS, 0.25f, 0.5f);
            }
            worldIn.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + (double)random.nextFloat(), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }
}

