/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining.block.entity.custom;

import com.baisylia.modestmining.block.custom.ForgeBlock;
import com.baisylia.modestmining.block.entity.ModBlockEntities;
import com.baisylia.modestmining.recipe.AbstractForgeRecipe;
import com.baisylia.modestmining.recipe.ForgeRecipe;
import com.baisylia.modestmining.recipe.ForgeShapedRecipe;
import com.baisylia.modestmining.screen.ForgeMenu;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 72;
    private int litTime = 0;
    private int fuelAmount = 0;
    private static final int[] INGREDIENT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    static int countOutput = 1;
    private ContainerOpenersCounter openersCounter;
    private AbstractForgeRecipe currentRecipe = null;
    private final ItemStackHandler itemHandler = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            ForgeBlockEntity.this.m_6596_();
            if (slot < 9) {
                ForgeBlockEntity.this.resetProgress();
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public ForgeBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FORGE_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> ForgeBlockEntity.this.progress;
                    case 1 -> ForgeBlockEntity.this.maxProgress;
                    case 2 -> ForgeBlockEntity.this.litTime;
                    case 3 -> ForgeBlockEntity.this.fuelAmount;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        ForgeBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        ForgeBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        ForgeBlockEntity.this.litTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.modestmining.forge");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new ForgeMenu(pContainerId, pInventory, this, this.data);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (side == null && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (!this.f_58859_ && side != null && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("forge.progress", this.progress);
        tag.m_128405_("forge.lit_time", this.litTime);
        tag.m_128405_("forge.max_progress", this.maxProgress);
        tag.m_128405_("forge.fuel_amount", this.fuelAmount);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("forge.progress");
        this.litTime = nbt.m_128451_("forge.lit_time");
        this.maxProgress = nbt.m_128451_("forge.max_progress");
        this.fuelAmount = nbt.m_128451_("forge.fuel_amount");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ForgeBlockEntity pBlockEntity) {
        pBlockEntity.litTime = ForgeBlockEntity.isFueled(pBlockEntity, pPos, pLevel) ? --pBlockEntity.litTime : 0;
        if (ForgeBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            pBlockEntity.setChanged(pLevel, pPos, pState, true);
            if (pBlockEntity.progress == pBlockEntity.maxProgress) {
                ForgeBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
        }
    }

    private void setChanged(Level pLevel, BlockPos pPos, BlockState pState, boolean b) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)ForgeBlock.LIT, (Comparable)Boolean.valueOf(b)), 3);
        super.m_6596_();
    }

    private static boolean hasRecipe(ForgeBlockEntity entity) {
        Level level = entity.f_58857_;
        BlockPos pos = entity.m_58899_();
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        if (!inventory.m_8020_(10).m_41619_() && !inventory.m_8020_(10).m_41753_()) {
            return false;
        }
        if (entity.currentRecipe != null) {
            return ForgeBlockEntity.startCraftIfFueled(entity, pos, level, entity.currentRecipe.getCookTime());
        }
        Optional shapedMatch = level.m_7465_().m_44015_((RecipeType)ForgeShapedRecipe.Type.INSTANCE, (Container)inventory, level);
        Optional recipeMatch = level.m_7465_().m_44015_((RecipeType)ForgeRecipe.Type.INSTANCE, (Container)inventory, level);
        if (shapedMatch.isPresent()) {
            entity.currentRecipe = (AbstractForgeRecipe)shapedMatch.get();
            return ForgeBlockEntity.startCraftIfFueled(entity, pos, level, ((ForgeShapedRecipe)shapedMatch.get()).getCookTime());
        }
        if (recipeMatch.isPresent()) {
            entity.currentRecipe = (AbstractForgeRecipe)recipeMatch.get();
            return ForgeBlockEntity.startCraftIfFueled(entity, pos, level, ((ForgeRecipe)recipeMatch.get()).getCookTime());
        }
        entity.currentRecipe = null;
        return false;
    }

    static boolean startCraftIfFueled(ForgeBlockEntity entity, BlockPos pos, Level level, int progress) {
        if (!ForgeBlockEntity.isFueled(entity, pos, level) && !entity.burnFuel()) {
            return false;
        }
        entity.maxProgress = progress;
        return true;
    }

    static boolean isFueled(ForgeBlockEntity entity, BlockPos pos, Level level) {
        if (level.f_46443_) {
            return false;
        }
        if (entity.litTime > 0) {
            entity.setChanged(level, pos, entity.m_58900_(), true);
            return true;
        }
        entity.setChanged(level, pos, entity.m_58900_(), false);
        return false;
    }

    private boolean burnFuel() {
        ItemStack fuel;
        if (!this.f_58857_.f_46443_ && AbstractFurnaceBlockEntity.m_58399_((ItemStack)(fuel = this.itemHandler.getStackInSlot(9).m_41777_())) && this.litTime == 0) {
            this.fuelAmount = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44109_);
            this.litTime = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44109_);
            if (fuel.m_41613_() > 1) {
                fuel.m_41764_(fuel.m_41613_() - 1);
                this.itemHandler.setStackInSlot(9, fuel);
            } else {
                this.itemHandler.setStackInSlot(9, fuel.getCraftingRemainingItem());
            }
            return true;
        }
        return false;
    }

    private static void craftItem(ForgeBlockEntity entity) {
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        AbstractForgeRecipe currentRecipe = entity.currentRecipe;
        if (currentRecipe != null) {
            int i;
            for (i = 0; i < 9; ++i) {
                ItemStack slotStack = entity.itemHandler.getStackInSlot(i);
                if (!slotStack.hasCraftingRemainingItem()) continue;
                Direction direction = ((Direction)entity.m_58900_().m_61143_((Property)ForgeBlock.FACING)).m_122428_();
                double x = (double)entity.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
                double y = (double)entity.f_58858_.m_123342_() + 0.7;
                double z = (double)entity.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
                ForgeBlockEntity.spawnItemEntity(entity.f_58857_, entity.itemHandler.getStackInSlot(i).getCraftingRemainingItem(), x, y, z, (float)direction.m_122429_() * 0.08f, 0.25, (float)direction.m_122431_() * 0.08f);
            }
            for (i = 0; i < 9; ++i) {
                entity.itemHandler.extractItem(i, 1, false);
            }
            inventory.m_8020_(10).m_150930_(currentRecipe.m_8043_().m_41720_());
            entity.itemHandler.setStackInSlot(10, new ItemStack((ItemLike)currentRecipe.m_8043_().m_41720_(), entity.itemHandler.getStackInSlot(10).m_41613_() + entity.getTheCount(currentRecipe.m_8043_())));
            entity.resetProgress();
        }
    }

    public static void spawnItemEntity(Level level, ItemStack stack, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        entity.m_20334_(xMotion, yMotion, zMotion);
        level.m_7967_((Entity)entity);
    }

    private int getTheCount(ItemStack itemIn) {
        return itemIn.m_41613_();
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
        this.currentRecipe = null;
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            return INGREDIENT_SLOTS;
        }
        return new int[]{direction == Direction.DOWN ? 10 : 9};
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        if (slot == 10) {
            return false;
        }
        if (slot == 9) {
            return ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)RecipeType.f_44109_) > 0;
        }
        return true;
    }

    public boolean m_7155_(int slot, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(slot, itemStack);
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return true;
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.itemHandler.extractItem(slot, amount, false);
    }

    public ItemStack m_8016_(int slot) {
        return this.itemHandler.extractItem(slot, 1, false);
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        this.itemHandler.setStackInSlot(slot, itemStack);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < 11; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }
}

