/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining.integration.emi;

import com.baisylia.modestmining.integration.emi.AbstractForgingRecipe;
import com.baisylia.modestmining.integration.emi.EMIModestMiningPlugin;
import com.baisylia.modestmining.recipe.ForgeShapedRecipe;
import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.crafting.Ingredient;

public class ForgingShapedEmiRecipe
extends AbstractForgingRecipe {
    private final List<Ingredient> ingredients;
    private final int height;
    private final int width;

    public ForgingShapedEmiRecipe(ForgeShapedRecipe recipe) {
        super(recipe.m_6423_(), ForgingShapedEmiRecipe.padIngredients(recipe), recipe.m_8043_(), recipe.getCookTime());
        this.height = recipe.getHeight();
        this.width = recipe.getWidth();
        this.ingredients = recipe.m_7527_();
    }

    public EmiRecipeCategory getCategory() {
        return EMIModestMiningPlugin.SHAPED_FORGING;
    }

    public void addWidgets(WidgetHolder builder) {
        builder.addTexture(AbstractForgingRecipe.TEXTURE, 0, 0, 120, 60, 0, 0);
        int startX = 2;
        int startY = 4;
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                builder.addSlot(EmiIngredient.of((Ingredient)this.ingredients.get(index)), startX + x * 18, startY + y * 18).drawBack(false);
                ++index;
            }
        }
        ForgingShapedEmiRecipe.drawCookTime(this.cookTime, builder, 50, this.getDisplayWidth());
        builder.addAnimatedTexture(EmiTexture.FULL_FLAME, 66, 23, 6000, false, true, true);
        builder.addSlot((EmiIngredient)this.result, 97, 6).recipeContext((EmiRecipe)this).drawBack(false);
    }

    private static List<EmiIngredient> padIngredients(ForgeShapedRecipe recipe) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (x >= recipe.getWidth() || y >= recipe.getHeight() || i >= recipe.m_7527_().size()) {
                    list.add(EmiStack.EMPTY);
                    continue;
                }
                list.add(EmiIngredient.of((Ingredient)((Ingredient)recipe.m_7527_().get(i++))));
            }
        }
        return list;
    }
}

