/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining.screen;

import com.baisylia.modestmining.block.ModBlocks;
import com.baisylia.modestmining.block.entity.custom.ForgeBlockEntity;
import com.baisylia.modestmining.screen.ModMenuTypes;
import com.baisylia.modestmining.screen.slot.ModFuelSlot;
import com.baisylia.modestmining.screen.slot.ModResultSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ForgeMenu
extends AbstractContainerMenu {
    private final ForgeBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 11;

    public ForgeMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(4));
    }

    public ForgeMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.FORGE_MENU.get(), pContainerId);
        ForgeMenu.m_38869_((Container)inv, (int)11);
        this.blockEntity = (ForgeBlockEntity)entity;
        this.level = inv.f_35978_.f_19853_;
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 30, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 48, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 66, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 30, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 48, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 5, 66, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 6, 30, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 7, 48, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 8, 66, 53));
            this.m_38897_((Slot)new ModFuelSlot((IItemHandler)handler, 9, 93, 53));
            this.m_38897_((Slot)new ModResultSlot((IItemHandler)handler, 10, 124, 19));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public boolean isFueled() {
        return (Boolean)this.blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61443_);
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public int getLitTime() {
        int litTime = this.data.m_6413_(2);
        int fuel = this.data.m_6413_(3);
        float percentage = (float)litTime / (float)fuel;
        return (int)(percentage *= 17.0f);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (AbstractFurnaceBlockEntity.m_58399_((ItemStack)sourceStack) && !this.m_38903_(sourceStack, 45, 47, false)) {
                return ItemStack.f_41583_;
            }
            if (!this.m_38903_(sourceStack, 36, 47, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 47) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return ForgeMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.FORGE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 86 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 144));
        }
    }
}

