/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining;

import com.baisylia.modestmining.block.ModBlocks;
import com.baisylia.modestmining.block.entity.ModBlockEntities;
import com.baisylia.modestmining.effect.ModEffects;
import com.baisylia.modestmining.entity.ModEntityTypes;
import com.baisylia.modestmining.entity.client.ClamRenderer;
import com.baisylia.modestmining.integration.everycompat.EveryCompatIntegration;
import com.baisylia.modestmining.item.ModItems;
import com.baisylia.modestmining.recipe.ModRecipes;
import com.baisylia.modestmining.screen.ForgeScreen;
import com.baisylia.modestmining.screen.ModMenuTypes;
import com.baisylia.modestmining.sounds.ModSounds;
import com.baisylia.modestmining.world.feature.ModConfiguredFeatures;
import com.baisylia.modestmining.world.feature.ModPlacedFeatures;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="modestmining")
public class ModestMining {
    public static final String MOD_ID = "modestmining";
    private static final Logger LOGGER = LogUtils.getLogger();

    public ModestMining() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::addPackFinders);
        ModEffects.register(eventBus);
        ModItems.register(eventBus);
        ModBlocks.register(eventBus);
        ModBlockEntities.register(eventBus);
        ModConfiguredFeatures.register(eventBus);
        ModPlacedFeatures.register(eventBus);
        ModMenuTypes.register(eventBus);
        ModRecipes.register(eventBus);
        ModEntityTypes.register(eventBus);
        GeckoLib.initialize();
        ModSounds.SOUND_EVENTS.register(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (ModList.get().isLoaded("everycomp")) {
            EveryCompatIntegration.register();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntityTypes.CLAM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, Mob::m_217057_);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            ModestMining.registerBuiltinResourcePack(event, Component.m_237113_((String)"Modest Mining Materials"), "modestmining_materials");
        }
    }

    private static void registerBuiltinResourcePack(AddPackFindersEvent event, MutableComponent name, String folder) {
        event.addRepositorySource((consumer, constructor) -> {
            block7: {
                ResourceLocation res = new ResourceLocation(MOD_ID, folder);
                IModFile file = ModList.get().getModFileById(MOD_ID).getFile();
                try (PathPackResources pack = new PathPackResources(res.toString(), file.findResource(new String[]{"resourcepacks/" + folder}));){
                    consumer.accept(constructor.create(res.toString(), (Component)name, false, () -> pack, (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_), Pack.Position.BOTTOM, PackSource.f_10528_, false));
                }
                catch (IOException e) {
                    if (DatagenModLoader.isRunningDataGen()) break block7;
                    e.printStackTrace();
                }
            }
        });
    }

    @Mod.EventBusSubscriber(modid="modestmining", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.CLAM.get()), ClamRenderer::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.FORGE_MENU.get()), ForgeScreen::new);
        }
    }
}

