/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractForgingRecipe
implements EmiRecipe {
    public static final ResourceLocation TEXTURE = new ResourceLocation("modestmining", "textures/gui/forge_gui_jei.png");
    final List<EmiIngredient> ingredients;
    final int cookTime;
    final EmiStack result;
    final ResourceLocation id;

    public AbstractForgingRecipe(ResourceLocation id, List<EmiIngredient> ingredients, ItemStack resultItem, int cookTime) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = EmiStack.of((ItemStack)resultItem);
        this.cookTime = cookTime;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.ingredients;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.result);
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 60;
    }

    protected static void drawCookTime(int cookTime, WidgetHolder builder, int y, int width) {
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"emi.cooking.time", (Object[])new Object[]{cookTimeSeconds});
            builder.addFillingArrow(63, 4, cookTime * 100).tooltipText(Collections.singletonList(timeString));
        }
    }
}

