/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining.integration.jei;

import com.baisylia.modestmining.block.ModBlocks;
import com.baisylia.modestmining.integration.jei.JEIModestMiningPlugin;
import com.baisylia.modestmining.recipe.ForgeShapedRecipe;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ForgingShapedRecipeCategory
implements IRecipeCategory<ForgeShapedRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("modestmining", "forging_shaped");
    public static final ResourceLocation TEXTURE = new ResourceLocation("modestmining", "textures/gui/forge_gui_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final int regularCookTime = 400;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableAnimated animatedFlame;

    public ForgingShapedRecipeCategory(final IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 120, 60);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FORGE.get()));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(TEXTURE, 123, 0, 23, 18).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
        this.staticFlame = helper.createDrawable(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 82, 114, 14, 14);
        this.animatedFlame = helper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void draw(ForgeShapedRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(poseStack, 66, 23);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(poseStack, 63, 4);
        this.drawCookTime(recipe, poseStack, 50);
    }

    protected void drawCookTime(ForgeShapedRecipe recipe, PoseStack poseStack, int y) {
        int cookTime = recipe.getCookTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            fontRenderer.m_92889_(poseStack, (Component)timeString, (float)(this.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected IDrawableAnimated getArrow(ForgeShapedRecipe recipe) {
        int cookTime = recipe.getCookTime();
        if (cookTime <= 0) {
            cookTime = 400;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public RecipeType<ForgeShapedRecipe> getRecipeType() {
        return JEIModestMiningPlugin.FORGING_SHAPED_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"recipe.modestmining.shaped_forging");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ForgeShapedRecipe recipe, IFocusGroup focuses) {
        int startX = 3;
        int startY = 5;
        int index = 0;
        for (int y = 0; y < recipe.getHeight(); ++y) {
            for (int x = 0; x < recipe.getWidth(); ++x) {
                builder.addSlot(RecipeIngredientRole.INPUT, startX + x * 18, startY + y * 18).addIngredients((Ingredient)recipe.m_7527_().get(index));
                ++index;
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 6).addItemStack(recipe.m_8043_());
    }
}

