/*
 * Decompiled with CFR 0.152.
 */
package com.baisylia.modestmining.recipe;

import com.baisylia.modestmining.recipe.AbstractForgeRecipe;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;

public class ForgeShapedRecipe
extends AbstractForgeRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    final int width;
    final int height;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final int cookTime;
    private final boolean isSimple;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public ForgeShapedRecipe(int width, int height, ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, int cookTime) {
        super(id, output, recipeItems, cookTime);
        this.width = width;
        this.height = height;
        this.output = output;
        this.recipeItems = recipeItems;
        this.cookTime = cookTime;
        this.isSimple = recipeItems.stream().allMatch(Ingredient::isSimple);
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        ItemStack outputSlot = pContainer.m_8020_(10);
        if (!outputSlot.m_41619_() && !ItemStack.m_41746_((ItemStack)this.m_8043_(), (ItemStack)outputSlot)) {
            return false;
        }
        if (!outputSlot.m_41619_() && outputSlot.m_41613_() >= outputSlot.m_41741_()) {
            return false;
        }
        boolean[][] slotUsed = new boolean[3][3];
        for (int offsetX = 0; offsetX <= 3 - this.getWidth(); ++offsetX) {
            for (int offsetY = 0; offsetY <= 3 - this.getHeight(); ++offsetY) {
                if (!this.checkIngredients(pContainer, offsetX, offsetY, slotUsed) || !this.areOtherSlotsEmpty(pContainer, offsetX, offsetY)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areOtherSlotsEmpty(SimpleContainer pContainer, int offsetX, int offsetY) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemStack;
                if (i >= offsetX && i < offsetX + this.getWidth() && j >= offsetY && j < offsetY + this.getHeight() || (itemStack = pContainer.m_8020_(i + j * 3)).m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkIngredients(SimpleContainer pContainer, int offsetX, int offsetY, boolean[][] slotUsed) {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                ItemStack gridStack;
                int gridX = i + offsetX;
                int gridY = j + offsetY;
                if (gridX >= 3 || gridY >= 3) continue;
                if (slotUsed[gridX][gridY]) {
                    return false;
                }
                Ingredient recipeIngredient = (Ingredient)this.recipeItems.get(i + j * this.getWidth());
                if (!recipeIngredient.test(gridStack = pContainer.m_8020_(gridX + gridY * 3))) {
                    return false;
                }
                slotUsed[gridX][gridY] = true;
            }
        }
        return true;
    }

    public ItemStack assemble(SimpleContainer p_44001_) {
        return this.output;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    static NonNullList<Ingredient> dissolvePattern(String[] p_44203_, Map<String, Ingredient> p_44204_, int p_44205_, int p_44206_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(p_44205_ * p_44206_), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(p_44204_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_44203_.length; ++i) {
            for (int j = 0; j < p_44203_[i].length(); ++j) {
                String s = p_44203_[i].substring(j, j + 1);
                Ingredient ingredient = p_44204_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_44205_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... p_44187_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_44187_.length; ++i1) {
            String s = p_44187_[i1];
            i = Math.min(i, ForgeShapedRecipe.firstNonSpace(s));
            int j1 = ForgeShapedRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_44187_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_44187_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_44187_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(p_151273_ -> ForgeHooks.hasNoElements((Ingredient)p_151273_));
    }

    private static int firstNonSpace(String p_44185_) {
        int i;
        for (i = 0; i < p_44185_.length() && p_44185_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String p_44201_) {
        int i;
        for (i = p_44201_.length() - 1; i >= 0 && p_44201_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray p_44197_) {
        String[] astring = new String[p_44197_.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)p_44197_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject p_44211_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_44211_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemStackFromJson(JsonObject p_151275_) {
        return CraftingHelper.getItemStack((JsonObject)p_151275_, (boolean)true, (boolean)true);
    }

    public static Item itemFromJson(JsonObject p_151279_) {
        String s = GsonHelper.m_13906_((JsonObject)p_151279_, (String)"item");
        Item item = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + s);
        }
        return item;
    }

    public static class Serializer
    implements RecipeSerializer<ForgeShapedRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final ResourceLocation NAME = new ResourceLocation("modestmining", "forging_shaped");

        public ForgeShapedRecipe fromJson(ResourceLocation id, JsonObject json) {
            Map<String, Ingredient> map = ForgeShapedRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] astring = ForgeShapedRecipe.shrink(ForgeShapedRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = astring[0].length();
            int height = astring.length;
            NonNullList<Ingredient> nonnulllist = ForgeShapedRecipe.dissolvePattern(astring, map, width, height);
            ItemStack itemstack = ForgeShapedRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int cookTimeIn = GsonHelper.m_13824_((JsonObject)json, (String)"cooktime", (int)200);
            return new ForgeShapedRecipe(width, height, id, itemstack, nonnulllist, cookTimeIn);
        }

        public ForgeShapedRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int width = buf.m_130242_();
            int height = buf.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack itemstack = buf.m_130267_();
            int cookTimeIn = buf.m_130242_();
            return new ForgeShapedRecipe(width, height, id, itemstack, (NonNullList<Ingredient>)nonnulllist, cookTimeIn);
        }

        public void toNetwork(FriendlyByteBuf buf, ForgeShapedRecipe recipe) {
            buf.m_130130_(recipe.width);
            buf.m_130130_(recipe.height);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_());
            buf.m_130130_(recipe.cookTime);
        }
    }

    public static class Type
    implements RecipeType<ForgeShapedRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "forging_shaped";

        private Type() {
        }
    }
}

