#version 330

#moj_import <fog.glsl>
#moj_import <color.glsl>
#moj_import <dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
#ifdef PER_FACE_LIGHTING
in vec4 vertexPerFaceColorBack;
in vec4 vertexPerFaceColorFront;
#else
in vec4 vertexColor;
#endif
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0);
#ifdef ALPHA_CUTOUT
    if (tex2DBiLinearAlpha(Sampler0, texCoord0) < 0.5) {
        discard;
    }
#endif
#ifdef ALPHA_CUTOUT_JAGGED
    if (color.a < ALPHA_CUTOUT_JAGGED) {
        discard;
    }
#endif

    vec4 light = vec4(1.0, 1.0, 1.0, 1.0);
#ifndef EMISSIVE
    light *= lightMapColor;
#endif

    vec4 overlay = overlayColor;
#ifdef NO_OVERLAY
    overlay = vec4(1.0, 1.0, 1.0, 1.0);
#endif

#ifdef PER_FACE_LIGHTING
    fragColor = shadeEntity(color, gl_FrontFacing ? vertexPerFaceColorFront : vertexPerFaceColorBack, ColorModulator, light, overlay, sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
#else
    fragColor = shadeEntity(color, vertexColor, ColorModulator, light, overlay, sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
#endif
}
