#version 150

#moj_import <color.glsl>
#moj_import <fog.glsl>
#moj_import <dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0).rrrr * vertexColor;
    if (color.a < 0.01) {
		  discard;
    }

    color = outlineTexture(Sampler0, texCoord0, color);

    fragColor = apply_fog(color * ColorModulator, sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
}
