#version 150

#moj_import <fog.glsl>
#moj_import <color.glsl>
#moj_import <dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * ColorModulator;
    if (color.r == 1 && color.g == 0 && color.b == 1) {
        discard;
    }
#ifdef ALPHA_CUTOUT
    if (tex2DBiLinearAlpha(Sampler0, texCoord0) < 0.5) {
        discard;
    } 
    else if (color.r == 0 && color.g == 0 && color.b == 0) {
        color = tex2DBiLinear(Sampler0, texCoord0);
    }
#endif
#ifdef TRANSLUCENT
    color = shadeTranslucent(color, vertexColor, vec4(1.0, 1.0, 1.0, 1.0), sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
#else
    color = shade(color, vertexColor, vec4(1.0, 1.0, 1.0, 1.0), sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
#endif
    fragColor = color;
}
