/*
 * Decompiled with CFR 0.152.
 */
package org.macver.blip;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.macver.blip.FuzzyScore;
import org.macver.blip.mixin.client.PlayerInventoryAccessor;

@Environment(value=EnvType.CLIENT)
public class ItemSearcher {
    private static final FuzzyScore fuzzyScore = new FuzzyScore(Locale.ENGLISH);

    public List<class_1792> searchItems(String query) {
        Stream<class_1792> items;
        if (class_310.method_1551().field_1724.method_31549().field_7477) {
            items = class_7923.field_41178.method_10220();
        } else {
            PlayerInventoryAccessor inventory = (PlayerInventoryAccessor)class_310.method_1551().field_1724.method_31548();
            items = inventory.getMain().stream().filter(stack -> !stack.method_7960()).map(class_1799::method_7909).distinct();
        }
        return items.map(item -> {
            String itemName = item.method_63680().getString();
            int fuzzy = fuzzyScore.fuzzyScore(itemName, query);
            int keyword = this.keywordScore(itemName, query);
            int finalScore = fuzzy + 10 * keyword;
            int nameLength = itemName.length();
            return new ScoredItem((class_1792)item, finalScore, nameLength);
        }).filter(si -> si.score > 0).sorted().map(si -> si.item).toList();
    }

    private int keywordScore(@NotNull String term, @NotNull String query) {
        HashSet<String> termWords = new HashSet<String>(Arrays.asList(term.toLowerCase().split("\\W+")));
        HashSet<String> queryWords = new HashSet<String>(Arrays.asList(query.toLowerCase().split("\\W+")));
        termWords.retainAll(queryWords);
        return termWords.size();
    }

    @Environment(value=EnvType.CLIENT)
    private record ScoredItem(class_1792 item, int score, int length) implements Comparable<ScoredItem>
    {
        @Override
        public int compareTo(@NotNull ScoredItem other) {
            if (this.score != other.score) {
                return Integer.compare(other.score, this.score);
            }
            return Integer.compare(this.length, other.length);
        }
    }
}

