/*
 * Decompiled with CFR 0.152.
 */
package org.macver.blip;

import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7842;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.macver.blip.ItemSearcher;
import org.macver.blip.mixin.client.PlayerInventoryAccessor;

@Environment(value=EnvType.CLIENT)
public class SearchBox
extends class_437 {
    class_342 textFieldWidget;
    final ItemSearcher itemSearcher = new ItemSearcher();

    public SearchBox(class_2561 title) {
        super(title);
    }

    protected void method_25426() {
        int boxWidth = 200;
        int boxHeight = 20;
        int x = (this.field_22789 - boxWidth) / 2;
        int y = (this.field_22790 - boxHeight) / 2 - 40;
        this.textFieldWidget = new class_342(this.field_22793, x, y, boxWidth, boxHeight, class_2561.method_30163((String)"Search"));
        this.textFieldWidget.method_1863(this::searchItems);
        this.method_37063((class_364)this.textFieldWidget);
        this.method_48265((class_364)this.textFieldWidget);
    }

    public boolean method_25404(@NotNull class_11908 keyInput) {
        int keyCode = keyInput.comp_4795();
        if (keyCode == 257 || keyCode == 335) {
            String input = this.textFieldWidget.method_1882();
            List<class_1792> results = this.searchItems(input);
            if (!results.isEmpty()) {
                boolean countSpecified = false;
                class_1799 stack = new class_1799((class_1935)results.getFirst());
                try {
                    int count = this.getCount(input);
                    stack.method_7939(count);
                    countSpecified = true;
                }
                catch (Exception count) {
                    // empty catch block
                }
                if (stack.method_7947() == 0) {
                    this.field_22787.method_1507(null);
                    return true;
                }
                class_746 player = this.field_22787.field_1724;
                class_1661 inventory = player.method_31548();
                int selectedSlot = ((PlayerInventoryAccessor)inventory).getSelectedSlot();
                if (!countSpecified) {
                    int slotWithStack = -1;
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        if (!inventory.method_5438(i).method_31574(stack.method_7909())) continue;
                        slotWithStack = i;
                        break;
                    }
                    if (slotWithStack != -1) {
                        this.switchHandToItemStack(slotWithStack, inventory, selectedSlot);
                    } else if (player.method_31549().field_7477) {
                        this.giveStack(inventory, selectedSlot, stack);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"message.survial_not_enough_items").method_36136(class_2583.field_24360.method_10977(class_124.field_1061)).getFirst(), true);
                    }
                } else if (player.method_31549().field_7477) {
                    this.giveStack(inventory, selectedSlot, stack);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.not_supported").method_36136(class_2583.field_24360.method_10977(class_124.field_1061)).getFirst(), true);
                }
            }
            this.field_22787.method_1507(null);
            return true;
        }
        return super.method_25404(keyInput);
    }

    private void giveStack(@NotNull class_1661 inventory, int selectedSlot, class_1799 stack) {
        if (inventory.method_5438(selectedSlot).method_7960()) {
            this.setStackToSlot(stack, selectedSlot);
        } else {
            int newSlot = SearchBox.findEmptyHotbarSlot(selectedSlot, inventory);
            if (newSlot != -1) {
                inventory.method_61496(newSlot);
                this.setStackToSlot(stack, newSlot);
            } else {
                int emptySlot = inventory.method_7376();
                if (emptySlot != -1) {
                    this.swapSlots(emptySlot, selectedSlot);
                }
                this.setStackToSlot(stack, selectedSlot);
            }
        }
    }

    private void swapSlots(int slot1, int slot2) {
        this.field_22787.field_1761.method_2906(this.field_22787.field_1724.field_7498.field_7763, slot1, slot2, class_1713.field_7791, (class_1657)this.field_22787.field_1724);
    }

    private static int findEmptyHotbarSlot(int selectedSlot, class_1661 inventory) {
        int i;
        int newSlot = -1;
        for (i = selectedSlot + 1; i < 9; ++i) {
            if (!inventory.method_5438(i).method_7960()) continue;
            newSlot = i;
            break;
        }
        if (newSlot == -1) {
            for (i = 0; i < selectedSlot; ++i) {
                if (!inventory.method_5438(i).method_7960()) continue;
                newSlot = i;
                break;
            }
        }
        return newSlot;
    }

    private void setStackToSlot(class_1799 stack, int selectedSlot) {
        if (selectedSlot == 0) {
            selectedSlot = 40;
            this.field_22787.field_1761.method_2909(stack, selectedSlot);
            this.swapSlots(selectedSlot, 0);
            this.field_22787.field_1761.method_2909(new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60654((String)"air"))), selectedSlot);
            this.swapSlots(selectedSlot, selectedSlot);
            return;
        }
        this.field_22787.field_1761.method_2909(stack, selectedSlot);
        this.swapSlots(selectedSlot, selectedSlot);
    }

    private void switchHandToItemStack(int slotWithStack, class_1661 inventory, int selectedSlot) {
        if (slotWithStack < 9) {
            inventory.method_61496(slotWithStack);
        } else {
            this.swapSlots(slotWithStack, selectedSlot);
        }
    }

    public List<class_1792> searchItems(@NotNull String query) {
        if (!query.isEmpty() && Character.isDigit(query.charAt(query.length() - 1))) {
            String[] split = query.split(" ");
            String s = split[split.length - 1];
            try {
                Integer.parseInt(s);
                int endIndex = query.length() - s.length();
                String substring = query.substring(0, endIndex);
                return this.itemSearcher.searchItems(substring.strip().toLowerCase(Locale.ROOT));
            }
            catch (NumberFormatException endIndex) {}
        } else if (!query.isEmpty() && Character.isDigit(query.charAt(0))) {
            String[] split = query.split(" ");
            String s = split[0];
            try {
                Integer.parseInt(s);
                int startIndex = s.length();
                String substring = query.substring(startIndex);
                return this.itemSearcher.searchItems(substring.strip().toLowerCase(Locale.ROOT));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.itemSearcher.searchItems(query.strip().toLowerCase(Locale.ROOT));
    }

    private int getCount(@NotNull String input) {
        if (Character.isDigit(input.charAt(input.length() - 1))) {
            String[] split = input.split(" ");
            String s = split[split.length - 1];
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (Character.isDigit(input.charAt(0))) {
            String[] split = input.split(" ");
            String s = split[0];
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new NoSuchElementException();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        String input = this.textFieldWidget.method_1882();
        List suggestions = this.searchItems(input).stream().limit(5L).toList();
        int boxWidth = 200;
        int boxHeight = 20;
        int x = (this.field_22789 - boxWidth) / 2;
        int y = (this.field_22790 - boxHeight) / 2 - 10;
        for (int i = 0; i < suggestions.size(); ++i) {
            class_7842 textWidget;
            class_1792 item = (class_1792)suggestions.get(i);
            context.method_51427(item.method_7854(), x, y - 5 + i * 20);
            try {
                int count = this.getCount(input);
                textWidget = new class_7842(class_2561.method_30163((String)(count + " " + item.method_63680().getString())), this.field_22793);
                textWidget.method_48229(x + 20, y + i * 20);
                textWidget.method_25394(context, mouseX, mouseY, delta);
                continue;
            }
            catch (NoSuchElementException ignored) {
                textWidget = new class_7842(item.method_63680(), this.field_22793);
                textWidget.method_48229(x + 20, y + i * 20);
                textWidget.method_25394(context, mouseX, mouseY, delta);
            }
        }
    }
}

