/*
 * Decompiled with CFR 0.152.
 */
package oshawatt.challengecards.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import oshawatt.challengecards.datacomponents.ModComponents;
import oshawatt.challengecards.items.ModItems;
import oshawatt.challengecards.screen.CardButtonWidget;
import oshawatt.challengecards.screen.CardChecklistScreenHandler;
import oshawatt.challengecards.screen.CardChecklistTabWidget;

@Environment(value=EnvType.CLIENT)
public class CardChecklistScreen
extends class_465<CardChecklistScreenHandler> {
    public static final class_2960 GUI_TEXTURE = class_2960.method_60655((String)"challenge-cards", (String)"textures/gui/gui_checklist.png");
    public static final class_2960 identifier2 = class_2960.method_60655((String)"challenge-cards", (String)"textures/gui/gui_checklist_tab.png");
    private int x;
    private int y;
    private boolean shouldScroll = false;
    private final int cardsPerRow = 4;
    private final int rowsPerPage = 4;
    private List<class_1792> pickaxeCards = List.of(ModItems.CARD_COAL_ORE, ModItems.CARD_COPPER_ORE, ModItems.CARD_IRON_ORE, ModItems.CARD_GOLD_ORE, ModItems.CARD_LAPIS_ORE, ModItems.CARD_REDSTONE_ORE, ModItems.CARD_DIAMOND_ORE, ModItems.CARD_EMERALD_ORE, ModItems.CARD_DS_COAL_ORE, ModItems.CARD_DS_COPPER_ORE, ModItems.CARD_DS_IRON_ORE, ModItems.CARD_DS_GOLD_ORE, ModItems.CARD_DS_LAPIS_ORE, ModItems.CARD_DS_REDSTONE_ORE, ModItems.CARD_DS_DIAMOND_ORE, ModItems.CARD_DS_EMERALD_ORE);
    private List<class_1792> swordCards = List.of(ModItems.CARD_ZOMBIE_PIGLIN, ModItems.CARD_STRIDER, ModItems.CARD_MAGMA_CUBE, ModItems.CARD_STRAY, ModItems.CARD_PHANTOM, ModItems.CARD_BOGGED, ModItems.CARD_ELDER_GUARDIAN, ModItems.CARD_ENDERMITE, ModItems.CARD_SLIME, ModItems.CARD_VEX, ModItems.CARD_PILLAGER, ModItems.CARD_RAVAGER, ModItems.CARD_VINDICATOR, ModItems.CARD_EVOKER, ModItems.CARD_HUSK, ModItems.CARD_PIGLIN_BRUTE, ModItems.CARD_SHULKER, ModItems.CARD_SILVERFISH, ModItems.CARD_SKELETON, ModItems.CARD_WITCH, ModItems.CARD_WITHER_SKELETON, ModItems.CARD_ZOGLIN, ModItems.CARD_ZOMBIE, ModItems.CARD_ZOMBIE_VILLAGER, ModItems.CARD_BLAZE, ModItems.CARD_BREEZE, ModItems.CARD_CREEPER, ModItems.CARD_GHAST, ModItems.CARD_GUARDIAN, ModItems.CARD_HOGLIN, ModItems.CARD_PIGLIN, ModItems.CARD_ENDERMAN);
    private List<class_1792> carrotCards = List.of(new class_1792[]{ModItems.CARD_PIG, ModItems.CARD_COW, ModItems.CARD_SHEEP, ModItems.CARD_CHICKEN});
    private List<class_1792> invertCards = List.of(ModItems.CARD_ZOMBIE_PIGLIN_INVERT, ModItems.CARD_STRIDER_INVERT, ModItems.CARD_MAGMA_CUBE_INVERT, ModItems.CARD_STRAY_INVERT, ModItems.CARD_PHANTOM_INVERT, ModItems.CARD_BOGGED_INVERT, ModItems.CARD_ELDER_GUARDIAN_INVERT, ModItems.CARD_ENDERMITE_INVERT, ModItems.CARD_SLIME_INVERT, ModItems.CARD_VEX_INVERT, ModItems.CARD_PILLAGER_INVERT, ModItems.CARD_RAVAGER_INVERT, ModItems.CARD_VINDICATOR_INVERT, ModItems.CARD_EVOKER_INVERT, ModItems.CARD_HUSK_INVERT, ModItems.CARD_PIGLIN_BRUTE_INVERT, ModItems.CARD_SHULKER_INVERT, ModItems.CARD_SILVERFISH_INVERT, ModItems.CARD_SKELETON_INVERT, ModItems.CARD_WITCH_INVERT, ModItems.CARD_WITHER_SKELETON_INVERT, ModItems.CARD_ZOGLIN_INVERT, ModItems.CARD_ZOMBIE_INVERT, ModItems.CARD_ZOMBIE_VILLAGER_INVERT, ModItems.CARD_BLAZE_INVERT, ModItems.CARD_BREEZE_INVERT, ModItems.CARD_CREEPER_INVERT, ModItems.CARD_GHAST_INVERT, ModItems.CARD_GUARDIAN_INVERT, ModItems.CARD_HOGLIN_INVERT, ModItems.CARD_PIGLIN_INVERT, ModItems.CARD_ENDERMAN_INVERT, ModItems.CARD_PIG_INVERT, ModItems.CARD_COW_INVERT, ModItems.CARD_SHEEP_INVERT, ModItems.CARD_CHICKEN_INVERT, ModItems.CARD_LAPIS_ORE_INVERT, ModItems.CARD_REDSTONE_ORE_INVERT, ModItems.CARD_GOLD_ORE_INVERT, ModItems.CARD_EMERALD_ORE_INVERT, ModItems.CARD_IRON_ORE_INVERT, ModItems.CARD_COPPER_ORE_INVERT, ModItems.CARD_COAL_ORE_INVERT, ModItems.CARD_DS_COAL_ORE_INVERT, ModItems.CARD_DS_COPPER_ORE_INVERT, ModItems.CARD_DIAMOND_ORE_INVERT, ModItems.CARD_DS_GOLD_ORE_INVERT, ModItems.CARD_DS_IRON_ORE_INVERT, ModItems.CARD_DS_LAPIS_ORE_INVERT, ModItems.CARD_DS_REDSTONE_ORE_INVERT, ModItems.CARD_DS_EMERALD_ORE_INVERT, ModItems.CARD_DS_DIAMOND_ORE_INVERT);
    private List<class_1792> rareCards = List.of(new class_1792[]{ModItems.CARD_PIG_RARE, ModItems.CARD_ZOMBIE_PIGLIN_RARE, ModItems.CARD_WARDEN, ModItems.CARD_WITHER, ModItems.CARD_ENDER_DRAGON});
    private List<class_364> pageElements = new ArrayList<class_364>();
    private class_1799 checklistStack;

    public CardChecklistScreen(CardChecklistScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.checklistStack = inventory.field_7546.method_6047();
    }

    protected void method_25426() {
        this.x = (this.field_22789 - this.field_2792) / 2;
        this.y = (this.field_22790 - this.field_2779) / 2 - 20;
        switch (((CardChecklistScreenHandler)this.field_2797).GetActiveTabType()) {
            case Home: {
                this.OpenHome();
                break;
            }
            case Pickaxe: {
                this.OpenPickaxe();
                break;
            }
            case Sword: {
                this.OpenSword();
                break;
            }
            case Carrot: {
                this.OpenCarrot();
                break;
            }
            case Invert: {
                this.OpenInvert();
                break;
            }
            case Rare: {
                this.OpenRare();
            }
        }
        this.method_37063((class_364)new CardChecklistTabWidget(this.x + 160, this.y + 20, button -> this.OpenHome(), CardChecklistScreenHandler.TabType.Home));
        this.method_37063((class_364)new CardChecklistTabWidget(this.x + 160, this.y + 40, button -> this.OpenPickaxe(), CardChecklistScreenHandler.TabType.Pickaxe));
        this.method_37063((class_364)new CardChecklistTabWidget(this.x + 160, this.y + 60, button -> this.OpenSword(), CardChecklistScreenHandler.TabType.Sword));
        this.method_37063((class_364)new CardChecklistTabWidget(this.x + 160, this.y + 80, button -> this.OpenCarrot(), CardChecklistScreenHandler.TabType.Carrot));
        this.method_37063((class_364)new CardChecklistTabWidget(this.x + 160, this.y + 100, button -> this.OpenInvert(), CardChecklistScreenHandler.TabType.Invert));
        this.method_37063((class_364)new CardChecklistTabWidget(this.x + 160, this.y + 120, button -> this.OpenRare(), CardChecklistScreenHandler.TabType.Rare));
    }

    protected void method_2389(class_332 context, float deltaTicks, int mouseX, int mouseY) {
        context.method_25290(class_1921::method_62277, GUI_TEXTURE, this.x, this.y, 0.0f, 0.0f, 256, 256, 256, 256);
        if (((CardChecklistScreenHandler)this.field_2797).GetActiveTabType() == CardChecklistScreenHandler.TabType.Home) {
            int textX = this.x + 30;
            int textY = this.y + 20;
            class_310 client = class_310.method_1551();
            context.method_51439(client.field_1772, class_2561.method_30163((String)"Welcome to"), textX + 35, textY, -16777216, false);
            context.method_51439(client.field_1772, class_2561.method_30163((String)"Oshawatt's TCG Mod!"), textX + 15, textY + 10, -16777216, false);
            ArrayList checkedCards = new ArrayList((Collection)this.checklistStack.method_58695(ModComponents.CHECKLIST_COMPONENT, new ArrayList()));
            int pickaxeCardsCollected = 0;
            int swordCardsCollected = 0;
            int carrotCardsCollected = 0;
            int invertCardsCollected = 0;
            int rareCardsCollected = 0;
            int totalCards = this.pickaxeCards.size() + this.swordCards.size() + this.carrotCards.size() + this.invertCards.size() + this.rareCards.size();
            for (class_1792 item : this.pickaxeCards) {
                if (!checkedCards.contains(item.method_7876())) continue;
                ++pickaxeCardsCollected;
            }
            for (class_1792 item : this.swordCards) {
                if (!checkedCards.contains(item.method_7876())) continue;
                ++swordCardsCollected;
            }
            for (class_1792 item : this.carrotCards) {
                if (!checkedCards.contains(item.method_7876())) continue;
                ++carrotCardsCollected;
            }
            for (class_1792 item : this.invertCards) {
                if (!checkedCards.contains(item.method_7876())) continue;
                ++invertCardsCollected;
            }
            for (class_1792 item : this.rareCards) {
                if (!checkedCards.contains(item.method_7876())) continue;
                ++rareCardsCollected;
            }
            context.method_51439(client.field_1772, class_2561.method_30163((String)"Cards Collected:"), textX, textY + 50, -16777216, false);
            context.method_51439(client.field_1772, class_2561.method_30163((String)("Total: " + checkedCards.size() + "/" + totalCards)), textX, textY + 70, -16777216, false);
            context.method_51439(client.field_1772, class_2561.method_30163((String)("Pickaxe: " + pickaxeCardsCollected + "/" + this.pickaxeCards.size())), textX, textY + 80, -16777216, false);
            context.method_51439(client.field_1772, class_2561.method_30163((String)("Sword: " + swordCardsCollected + "/" + this.swordCards.size())), textX, textY + 90, -16777216, false);
            context.method_51439(client.field_1772, class_2561.method_30163((String)("Carrot: " + carrotCardsCollected + "/" + this.carrotCards.size())), textX, textY + 100, -16777216, false);
            context.method_51439(client.field_1772, class_2561.method_30163((String)("Inverted: " + invertCardsCollected + "/" + this.invertCards.size())), textX, textY + 110, -16777216, false);
            context.method_51439(client.field_1772, class_2561.method_30163((String)("Rare: " + rareCardsCollected + "/" + this.rareCards.size())), textX, textY + 120, -16777216, false);
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.shouldScroll) {
            int pageDiff = 0;
            if (verticalAmount > 0.0) {
                pageDiff = -1;
            } else if (verticalAmount < 0.0) {
                pageDiff = 1;
            }
            int cardListSize = this.GetCardListSize();
            if (cardListSize <= 0) {
                ((CardChecklistScreenHandler)this.field_2797).SetPage(0);
            } else {
                ((CardChecklistScreenHandler)this.field_2797).SetPage(Math.clamp((long)(((CardChecklistScreenHandler)this.field_2797).GetPage() + pageDiff), 0, this.GetCardListSize() / 4 - 4));
            }
        }
        this.DrawCards(((CardChecklistScreenHandler)this.field_2797).GetActiveTabType());
        return true;
    }

    protected void OpenHome() {
        this.DrawHome();
    }

    protected void OpenPickaxe() {
        ((CardChecklistScreenHandler)this.field_2797).SetPage(0);
        this.DrawCards(CardChecklistScreenHandler.TabType.Pickaxe);
    }

    protected void OpenSword() {
        ((CardChecklistScreenHandler)this.field_2797).SetPage(0);
        this.DrawCards(CardChecklistScreenHandler.TabType.Sword);
    }

    protected void OpenCarrot() {
        ((CardChecklistScreenHandler)this.field_2797).SetPage(0);
        this.DrawCards(CardChecklistScreenHandler.TabType.Carrot);
    }

    protected void OpenInvert() {
        ((CardChecklistScreenHandler)this.field_2797).SetPage(0);
        this.DrawCards(CardChecklistScreenHandler.TabType.Invert);
    }

    protected void OpenRare() {
        ((CardChecklistScreenHandler)this.field_2797).SetPage(0);
        this.DrawCards(CardChecklistScreenHandler.TabType.Rare);
    }

    protected void DrawHome() {
        ((CardChecklistScreenHandler)this.field_2797).SetActiveTab(CardChecklistScreenHandler.TabType.Home);
        for (class_364 element : this.pageElements) {
            this.method_37066(element);
        }
        this.pageElements.clear();
    }

    protected void DrawCards(CardChecklistScreenHandler.TabType openTab) {
        ((CardChecklistScreenHandler)this.field_2797).SetActiveTab(openTab);
        List<class_1792> itemList = this.getListFromTabType(openTab);
        this.shouldScroll = itemList.size() > 16;
        for (class_364 element : this.pageElements) {
            this.method_37066(element);
        }
        this.pageElements.clear();
        if (this.checklistStack.method_57826(ModComponents.CHECKLIST_COMPONENT)) {
            ArrayList checkedCards = new ArrayList((Collection)this.checklistStack.method_58695(ModComponents.CHECKLIST_COMPONENT, new ArrayList()));
            int cardX = this.x + 35;
            int cardY = this.y + 20;
            int pageStart = ((CardChecklistScreenHandler)this.field_2797).GetPage() * 4;
            for (int i = 0; i < 16 && i + pageStart < itemList.size(); ++i) {
                class_1792 item = itemList.get(i + pageStart);
                boolean checked = checkedCards.contains(item.method_7876());
                class_364 element = this.method_37063((class_364)new CardButtonWidget(cardX + i % 4 * 30, cardY + i / 4 * 40, button -> ((CardChecklistScreenHandler)this.field_2797).CheckItem(item), item, checked));
                this.pageElements.add(element);
            }
        }
    }

    protected int GetCardListSize() {
        CardChecklistScreenHandler.TabType openTab = ((CardChecklistScreenHandler)this.field_2797).GetActiveTabType();
        List<class_1792> itemList = this.getListFromTabType(openTab);
        return itemList.size();
    }

    protected List<class_1792> getListFromTabType(CardChecklistScreenHandler.TabType tabType) {
        List<class_1792> itemList = List.of();
        switch (tabType) {
            case Pickaxe: {
                itemList = this.pickaxeCards;
                break;
            }
            case Sword: {
                itemList = this.swordCards;
                break;
            }
            case Carrot: {
                itemList = this.carrotCards;
                break;
            }
            case Invert: {
                itemList = this.invertCards;
                break;
            }
            case Rare: {
                itemList = this.rareCards;
            }
        }
        return itemList;
    }
}

