/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.tomqnto.skywars.configs.MapConfig;
import me.tomqnto.skywars.configs.PluginConfigManager;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.game.GameMap;
import me.tomqnto.skywars.game.PlayerSession;
import me.tomqnto.skywars.menus.GamesMenu;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

/*
 * Exception performing whole class analysis ignored.
 */
public class GameManager {
    public static final HashMap<String, Game> games = new HashMap();
    private final HashMap<Player, PlayerSession> playerSessions = new HashMap();
    private final GamesMenu gamesMenu = new GamesMenu(this);
    private static Team spectators;

    public GameManager() {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        spectators = scoreboard.getTeam("spectators");
        if (spectators == null) {
            spectators = scoreboard.registerNewTeam("spectators");
        }
        spectators.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        spectators.setCanSeeFriendlyInvisibles(true);
        spectators.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
    }

    public Game createGame(GameConfiguration gameSettings) {
        List maps = GameManager.getValidMaps((String[])gameSettings.getAllowedMapIDs());
        if (maps.isEmpty()) {
            return null;
        }
        GameMap map = new GameMap((String)maps.get(new Random().nextInt(maps.size())));
        Game game = new Game(gameSettings, this, map);
        games.put(game.getId(), game);
        return game;
    }

    public PlayerSession getPlayerSession(Player player) {
        return (PlayerSession)this.playerSessions.get(player);
    }

    public PlayerSession createPlayerSession(Player player, Game game) {
        if (this.getPlayerSession(player) != null) {
            return null;
        }
        return this.playerSessions.put(player, new PlayerSession(player, game));
    }

    public void deletePlayerSession(Player player) {
        if (this.getPlayerSession(player) != null) {
            this.playerSessions.remove(player);
        }
    }

    public boolean hasActiveSession(Player player) {
        return this.getPlayerSession(player) != null;
    }

    public HashMap<String, Game> getGames() {
        return games;
    }

    public HashMap<Player, PlayerSession> getPlayerSessions() {
        return this.playerSessions;
    }

    public GamesMenu getGamesMenu() {
        return this.gamesMenu;
    }

    public Location getLobbyLocation() {
        return PluginConfigManager.getLobbyLocation();
    }

    public static String generateID() {
        String id = "sw-%s-%s-%s";
        String uuid = UUID.randomUUID().toString().substring(0, 8);
        String time = String.valueOf(System.currentTimeMillis());
        String time2 = time.substring(0, 4);
        time = time.substring(time.length() - 5);
        return id.formatted(time, uuid, time2);
    }

    public static List<String> getValidMaps(String[] tags) {
        List maps = MapConfig.getMaps();
        return maps.stream().filter(map -> Arrays.stream(tags).toList().contains(MapConfig.getID((String)map))).toList();
    }

    public static Team getSpectatorTeam() {
        return spectators;
    }

    public static int getPlayerCount(String configuration) {
        int count = 0;
        for (Game game : games.values()) {
            if (!game.getGameConfiguration().getName().equals(configuration)) continue;
            count += game.getPlayerCount();
        }
        return count;
    }

    public static int getPlayerCount() {
        int count = 0;
        for (Game game : games.values()) {
            count += game.getPlayerCount();
        }
        return count;
    }
}

