/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.menus.api;

import java.util.HashMap;
import java.util.function.Consumer;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.menus.api.Button;
import me.tomqnto.skywars.menus.api.Menu;
import me.tomqnto.skywars.menus.api.SimpleMenu;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleMenu
implements Menu,
Listener {
    private final Inventory inventory;
    private HashMap<Integer, Consumer<Player>> actionsMap = new HashMap();
    private HashMap<Integer, ItemStack> itemsMap = new HashMap();

    public SimpleMenu(Rows rows, Component title) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)rows.getSize(), (Component)title);
        SkywarsPlus.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)SkywarsPlus.getInstance());
    }

    public void click(Player player, int slot) {
        Consumer action = (Consumer)this.actionsMap.get(slot);
        if (action != null) {
            action.accept(player);
        }
    }

    public void setButton(int slot, Button button) {
        this.setItem(slot, button.getItemStack(), button.getAction());
    }

    public void setItem(int slot, ItemStack item) {
        this.setItem(slot, item, player -> {});
    }

    public void setItem(int slot, ItemStack item, Consumer<Player> action) {
        this.actionsMap.put(slot, action);
        this.itemsMap.put(slot, item);
        this.getInventory().setItem(slot, item);
    }

    public void update() {
        this.inventory.clear();
        this.itemsMap.clear();
        this.actionsMap.clear();
        this.onSetup();
    }

    public abstract void onSetup();

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public HashMap<Integer, ItemStack> getItemsMap() {
        return this.itemsMap;
    }

    public HashMap<Integer, Consumer<Player>> getActionsMap() {
        return this.actionsMap;
    }
}

