/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.command.arguments;

import java.util.Arrays;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.command.ArgumentExecutor;
import me.tomqnto.skywars.configs.GameConfigurationManager;
import me.tomqnto.skywars.game.GameConfiguration;
import org.bukkit.command.CommandSender;

public class CreateGameConfigArgument
implements ArgumentExecutor {
    public void execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            Message.MISSING_OR_INVALID_ARGUMENTS.send(sender);
            return;
        }
        String name = args[1];
        if (args.length < 9 && args.length > 1) {
            Message.MISSING_OR_INVALID_ARGUMENTS.send(sender);
            return;
        }
        if (GameConfigurationManager.doesExist((String)name)) {
            Message.send((CommandSender)sender, (String)"<red>A game config with this name already exists");
            return;
        }
        GameConfiguration gameConfiguration = new GameConfiguration(name, 6, 12, 1, 2, 1, 180, new String[]{"defaultmap1"});
        if (args.length > 1) {
            int minTeams = Integer.parseInt(args[2]);
            int maxTeams = Integer.parseInt(args[3]);
            int teamSize = Integer.parseInt(args[4]);
            int maxArmorNormal = Integer.parseInt(args[5]);
            int maxArmorOP = Integer.parseInt(args[6]);
            int chestRefillCooldown = Integer.parseInt(args[7]);
            String[] allowedMapIDs = Arrays.copyOfRange(args, 7, args.length);
            if (minTeams > maxTeams) {
                Message.send((CommandSender)sender, (String)"<red>Minimum team count must be less than or equal to maximum team count");
                return;
            }
            gameConfiguration = new GameConfiguration(name, minTeams, maxTeams, teamSize, maxArmorNormal, maxArmorOP, chestRefillCooldown, allowedMapIDs);
        }
        GameConfigurationManager.saveGameConfiguration((GameConfiguration)gameConfiguration);
        Message.send((CommandSender)sender, (String)("<green>Successfully created new game config: <yellow>" + name));
    }

    public String getUsage() {
        return "/skywarsplus create_config <name> [optional: <min teams> <max teams> <team size> <max armor normal chest> <max armor op chest> <map ids>]";
    }

    public String getDescription() {
        return "Create a new game config";
    }
}

