/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.command.arguments;

import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.command.ArgumentExecutor;
import me.tomqnto.skywars.game.GameManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LeaveGameArgument
implements ArgumentExecutor {
    private final GameManager gameManager;

    public LeaveGameArgument(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Message.PLAYER_ONLY_COMMAND.send(sender);
            return;
        }
        Player player = (Player)sender;
        if (!this.gameManager.hasActiveSession(player)) {
            Message.COMMAND_ONLY_IN_GAME.send((CommandSender)player);
            return;
        }
        Message.send((CommandSender)player, (String)"<gray>Left %s".formatted(this.gameManager.getPlayerSession(player).getGame().getId()));
        this.gameManager.getPlayerSession(player).getGame().playerLeave(player);
    }

    public String getUsage() {
        return "/skywarsplus leave";
    }

    public String getDescription() {
        return "Used to leave the game";
    }
}

