/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.command.arguments;

import java.util.List;
import java.util.Objects;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.command.ArgumentExecutor;
import me.tomqnto.skywars.configs.LootItemsConfig;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class SetLootItemsArgument
implements ArgumentExecutor {
    public void execute(CommandSender sender, String[] args) {
        BlockState inv;
        BlockState blockState;
        if (!(sender instanceof Player)) {
            Message.PLAYER_ONLY_COMMAND.send(sender);
            return;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            Message.MISSING_OR_INVALID_ARGUMENTS.send((CommandSender)player);
            return;
        }
        if (!List.of("normal", "middle").contains(args[1])) {
            Message.MISSING_OR_INVALID_ARGUMENTS.send((CommandSender)player);
            return;
        }
        Block block = player.getTargetBlockExact(5);
        if (block != null && (blockState = block.getState()) instanceof DoubleChest) {
            DoubleChest chest = (DoubleChest)blockState;
            inv = chest.getInventory();
            LootItemsConfig.setLootItems((Inventory)inv, (boolean)Objects.equals(args[1], "op"));
        } else if (block != null && (inv = block.getState()) instanceof Chest) {
            Chest chest = (Chest)inv;
            inv = chest.getBlockInventory();
            LootItemsConfig.setLootItems((Inventory)inv, (boolean)Objects.equals(args[1], "op"));
        } else {
            Message.send((CommandSender)player, (String)"<red>You must be looking at a chest");
            return;
        }
        Message.send((CommandSender)player, (String)"<green>Successfully set loot items for %s chests".formatted(args[1]));
    }

    public String getUsage() {
        return "/skywarsplus setloot <normal | op>";
    }

    public String getDescription() {
        return "Sets the loot for normal/op chests";
    }
}

