/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.configs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.menus.api.Button;
import me.tomqnto.skywars.menus.api.SimpleMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

/*
 * Exception performing whole class analysis ignored.
 */
public class JoinMenuConfig {
    public static final File file = new File(SkywarsPlus.getInstance().getDataFolder(), "join_menu.yml");
    public static FileConfiguration config;

    public static void load() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Integer> getSlots() {
        ConfigurationSection section = config.getConfigurationSection("buttons");
        Set keys = section.getKeys(false);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        keys.forEach(s -> slots.add(Integer.parseInt(s)));
        return slots;
    }

    public static SimpleMenu.Rows getRows() {
        return SimpleMenu.Rows.valueOf((String)config.getString("rows"));
    }

    public static String getName(int slot) {
        return config.getString("buttons." + slot + ".name");
    }

    public static List<String> getLore(int slot) {
        return config.getStringList("buttons." + slot + ".lore");
    }

    public static Material getMaterial(int slot) {
        return Material.valueOf((String)config.getString("buttons." + slot + ".material"));
    }

    public static boolean hasGlint(int slot) {
        return config.getBoolean("buttons." + slot + ".glint");
    }

    public static String getConfig(int slot) {
        return config.getString("buttons." + slot + ".config");
    }

    public static List<Consumer<Player>> getPlayerActions(int slot) {
        List actionsStr = config.getStringList("buttons." + slot + ".actions");
        ArrayList<Consumer<Player>> actions = new ArrayList<Consumer<Player>>();
        for (String action : actionsStr) {
            if (!action.startsWith("[COMMAND] ")) continue;
            actions.add(player -> player.performCommand(action.replace("[COMMAND] ", "")));
        }
        return actions;
    }

    public static List<Consumer<ConsoleCommandSender>> getConsoleActions(int slot) {
        List actionsStr = config.getStringList("buttons." + slot + ".actions");
        ArrayList<Consumer<ConsoleCommandSender>> actions = new ArrayList<Consumer<ConsoleCommandSender>>();
        for (String action : actionsStr) {
            if (!action.startsWith("[CONSOLE] ")) continue;
            actions.add(sender -> Bukkit.dispatchCommand((CommandSender)sender, (String)action.replace("[CONSOLE] ", "")));
        }
        return actions;
    }

    public static List<String> getMessages(int slot) {
        List actionsStr = config.getStringList("buttons." + slot + ".actions");
        ArrayList<String> msgs = new ArrayList<String>();
        for (String msg : actionsStr) {
            if (!msg.startsWith("[MESSAGE] ")) continue;
            msgs.add(msg.replace("[MESSAGE] ", ""));
        }
        return msgs;
    }

    public static void performPlayerActions(int slot, Player player) {
        for (Consumer action : JoinMenuConfig.getPlayerActions((int)slot)) {
            action.accept(player);
        }
    }

    public static void performConsoleActions(int slot, ConsoleCommandSender sender) {
        for (Consumer action : JoinMenuConfig.getConsoleActions((int)slot)) {
            action.accept(sender);
        }
    }

    public static void sendMessages(int slot, Player player) {
        JoinMenuConfig.getMessages((int)slot).forEach(msg -> player.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(msg)));
    }

    public static Button getButton(int slot) {
        String name = JoinMenuConfig.getName((int)slot);
        List loreString = JoinMenuConfig.getLore((int)slot);
        Material material = JoinMenuConfig.getMaterial((int)slot);
        boolean glint = JoinMenuConfig.hasGlint((int)slot);
        String config = JoinMenuConfig.getConfig((int)slot);
        if (name == null || loreString == null || material == null) {
            return null;
        }
        LegacyComponentSerializer serializer = LegacyComponentSerializer.legacyAmpersand();
        ArrayList lore = new ArrayList();
        loreString.forEach(string -> {
            if (config != null) {
                string = string.replace("%config-player-count%", String.valueOf(GameManager.getPlayerCount((String)config)));
            }
            string = string.replace("%player-count%", String.valueOf(GameManager.getPlayerCount()));
            lore.add(serializer.deserialize(string).decoration(TextDecoration.ITALIC, false));
        });
        if (config != null) {
            name = name.replace("%config-player-count%", String.valueOf(GameManager.getPlayerCount((String)config)));
        }
        name = name.replace("%player-count%", String.valueOf(GameManager.getPlayerCount()));
        TextComponent buttonName = serializer.deserialize(name);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.itemName((Component)buttonName);
        meta.lore(lore);
        if (glint) {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
        item.setItemMeta(meta);
        Consumer<Player> action = player1 -> {
            JoinMenuConfig.performPlayerActions((int)slot, (Player)player1);
            JoinMenuConfig.performConsoleActions((int)slot, (ConsoleCommandSender)Bukkit.getConsoleSender());
            JoinMenuConfig.sendMessages((int)slot, (Player)player1);
        };
        return new Button(item, action);
    }

    public static boolean isButtonValid(int slot) {
        return JoinMenuConfig.getButton((int)slot) != null;
    }

    static {
        if (!file.exists()) {
            SkywarsPlus.getInstance().saveResource("join_menu.yml", false);
        }
        JoinMenuConfig.load();
    }
}

