/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.configs;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import me.tomqnto.skywars.SkywarsPlus;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

/*
 * Exception performing whole class analysis ignored.
 */
public class LootItemsConfig {
    private static final File file = new File(SkywarsPlus.getInstance().getDataFolder(), "loot_items.yml");
    private static FileConfiguration config;

    public static void load() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void saveConfig() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LootItemsConfig.load();
    }

    public static void setLootItems(Inventory inventory, boolean isOPChestLoot) {
        String path = "loot-items.normal-chest";
        if (isOPChestLoot) {
            path = "loot-items.op-chest";
        }
        config.set(path, (Object)"");
        int key = 0;
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            ItemStack itemStack = inventory.getItem(slot);
            if (itemStack == null) continue;
            String name = itemStack.getItemMeta().getItemName();
            double chance = 1.0;
            int minAmount = 1;
            int maxAmount = itemStack.getAmount();
            config.set(path + "." + key, Map.of("item-stack", itemStack, "name", name, "min-amount", minAmount, "max-amount", maxAmount, "chance", chance));
            ++key;
        }
        LootItemsConfig.saveConfig();
    }

    public static void addLootItems(Inventory inventory, boolean isMiddleChestLoot) {
        String path = "loot-items.normal-chest";
        if (isMiddleChestLoot) {
            path = "loot-items.op-chest";
        }
        int key = Integer.parseInt((String)config.getConfigurationSection(path).getKeys(false).stream().toList().getLast());
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            ItemStack itemStack = inventory.getItem(slot);
            if (itemStack == null) continue;
            String name = itemStack.getItemMeta().getItemName();
            double chance = 1.0;
            int minAmount = 1;
            int maxAmount = itemStack.getAmount();
            config.set(path + "." + key, Map.of("item-stack", itemStack, "name", name, "min-amount", minAmount, "max-amount", maxAmount, "chance", chance));
            ++key;
        }
        LootItemsConfig.saveConfig();
    }

    public static ConfigurationSection getOPChestItemsSection() {
        return config.getConfigurationSection("loot-items.op-chest");
    }

    public static ConfigurationSection getNormalChestItemsSection() {
        return config.getConfigurationSection("loot-items.normal-chest");
    }

    static {
        if (!file.exists()) {
            SkywarsPlus.getInstance().saveResource("loot_items.yml", false);
        }
        LootItemsConfig.load();
    }
}

