/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.tomqnto.skywars.configs.LootItemsConfig;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameMap;
import me.tomqnto.skywars.game.LootItem;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ChestManager
implements Listener {
    private final Game game;
    private final GameMap map;
    private final World world;
    private final Set<Location> defaultNormalChestLocations = new HashSet();
    private final Set<Location> defaultOPChestLocations = new HashSet();
    private final Set<Location> playerPlacedChestLocations = new HashSet();
    private final Set<Location> openedChests = new HashSet();
    private final List<LootItem> normalChestItems = new ArrayList();
    private final List<LootItem> opChestItems = new ArrayList();

    public ChestManager(Game game) {
        ConfigurationSection section;
        this.game = game;
        this.map = game.getMap();
        this.world = this.map.getBukkitWorld();
        this.defaultOPChestLocations.addAll(this.map.getOPChestLocations());
        ConfigurationSection normalChestItemsSection = LootItemsConfig.getNormalChestItemsSection();
        ConfigurationSection opChestItemsSection = LootItemsConfig.getOPChestItemsSection();
        if (normalChestItemsSection == null || opChestItemsSection == null) {
            Bukkit.getLogger().severe("Please setup your 'loot-items' in loot_items.yml");
        }
        for (String key : normalChestItemsSection.getKeys(false)) {
            section = normalChestItemsSection.getConfigurationSection(key);
            this.normalChestItems.add(new LootItem(section));
        }
        for (String key : opChestItemsSection.getKeys(false)) {
            section = opChestItemsSection.getConfigurationSection(key);
            this.opChestItems.add(new LootItem(section));
        }
    }

    @EventHandler
    public void onChestPlace(BlockPlaceEvent event) {
        if (event.getBlockPlaced().getWorld() != this.world) {
            return;
        }
        if (!(event.getBlockPlaced().getType() != Material.CHEST || this.defaultNormalChestLocations.contains(event.getBlockPlaced().getLocation()) && this.defaultOPChestLocations.contains(event.getBlockPlaced().getLocation()))) {
            this.playerPlacedChestLocations.add(event.getBlockPlaced().getLocation());
        }
    }

    @EventHandler
    public void onChestBreak(BlockBreakEvent event) {
        if (event.getBlock().getWorld() != this.world) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            this.checkChest(chest);
        }
    }

    @EventHandler
    public void onChestOpen(InventoryOpenEvent event) {
        if (event.getPlayer().getWorld() != this.world) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            this.checkChest(chest);
        }
    }

    public void fill(Inventory inventory, boolean isOpChest) {
        inventory.clear();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        HashSet<LootItem> normalUsedItems = new HashSet<LootItem>();
        HashSet<LootItem> opUsedItems = new HashSet<LootItem>();
        int normalMaxArmor = this.game.getGameConfiguration().getMaxArmorPiecesNormalChest();
        int OPMaxArmor = this.game.getGameConfiguration().getMaxArmorPiecesOPChest();
        int normalArmorPieceCount = 0;
        int opArmorPieceCount = 0;
        for (int slotIndex = 0; slotIndex < inventory.getSize(); ++slotIndex) {
            LootItem randomItem = (LootItem)this.normalChestItems.get(random.nextInt(this.normalChestItems.size()));
            boolean isArmor = false;
            if (isOpChest) {
                randomItem = (LootItem)this.opChestItems.get(random.nextInt(this.opChestItems.size()));
            }
            if (!isOpChest) {
                if (normalUsedItems.contains(randomItem)) continue;
                type = randomItem.make(random).getType().name();
                if (type.endsWith("_HELMET") || type.endsWith("_CHESTPLATE") || type.endsWith("_LEGGINGS") || type.endsWith("_BOOTS")) {
                    isArmor = true;
                }
                if (isArmor) {
                    if (normalArmorPieceCount == normalMaxArmor) continue;
                    ++normalArmorPieceCount;
                }
                normalUsedItems.add(randomItem);
            } else {
                if (opUsedItems.contains(randomItem)) continue;
                opUsedItems.add(randomItem);
                type = randomItem.make(random).getType().name();
                if (type.endsWith("_HELMET") || type.endsWith("_CHESTPLATE") || type.endsWith("_LEGGINGS") || type.endsWith("_BOOTS")) {
                    isArmor = true;
                }
                if (isArmor) {
                    if (opArmorPieceCount == OPMaxArmor) continue;
                    ++opArmorPieceCount;
                }
            }
            if (!randomItem.shouldFill((Random)random)) continue;
            ItemStack itemStack = randomItem.make(random);
            inventory.setItem(slotIndex, itemStack);
        }
    }

    public void markAsOpened(Location location) {
        this.openedChests.add(location);
    }

    public boolean hasBeenOpened(Location location) {
        return this.openedChests.contains(location);
    }

    public void resetChests() {
        this.openedChests.clear();
        this.defaultNormalChestLocations.forEach(location -> {
            BlockState patt0$temp = location.getBlock().getState();
            if (patt0$temp instanceof Chest) {
                Chest chest = (Chest)patt0$temp;
                this.checkChest(chest);
            }
        });
        this.defaultOPChestLocations.forEach(location -> {
            BlockState patt0$temp = location.getBlock().getState();
            if (patt0$temp instanceof Chest) {
                Chest chest = (Chest)patt0$temp;
                this.checkChest(chest);
            }
        });
    }

    public void checkChest(Chest chest) {
        boolean playerPlaced = this.playerPlacedChestLocations.contains(chest.getLocation());
        boolean defaultNormalChest = this.defaultNormalChestLocations.contains(chest.getLocation());
        boolean defaultMiddleChest = this.defaultOPChestLocations.contains(chest.getLocation());
        if (playerPlaced && !defaultNormalChest && !defaultMiddleChest) {
            return;
        }
        if (!this.hasBeenOpened(chest.getLocation())) {
            this.markAsOpened(chest.getLocation());
            if (defaultMiddleChest) {
                this.fill(chest.getBlockInventory(), true);
            } else {
                this.defaultNormalChestLocations.add(chest.getLocation());
                this.fill(chest.getBlockInventory(), false);
            }
        }
    }
}

