/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.configs.PlayerConfig;
import me.tomqnto.skywars.configs.PluginConfigManager;
import me.tomqnto.skywars.game.ChestManager;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.game.GameMap;
import me.tomqnto.skywars.game.GameScoreboard;
import me.tomqnto.skywars.game.GameState;
import me.tomqnto.skywars.game.GameTeam;
import me.tomqnto.skywars.game.PlayerSession;
import me.tomqnto.skywars.tasks.ChestRefillCountdown;
import me.tomqnto.skywars.tasks.EndCountdown;
import me.tomqnto.skywars.tasks.StartCountdown;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class Game {
    private final GameConfiguration gameConfiguration;
    private final GameManager gameManager;
    private final GameMap map;
    private final ChestManager chestManager;
    private GameState gameState;
    private final String id;
    private final HashMap<Player, PlayerSession> gamePlayers;
    private final Set<GameTeam> gameTeams;
    private final StartCountdown startCountdown;
    private final ChestRefillCountdown chestRefillCountdown;
    private final HashSet<Player> alivePlayers;
    private final HashSet<Player> deadPlayers;
    private final HashMap<GameTeam, Location> teamSpawnLocations;
    private final int minPlayers;
    private final int maxPlayers;
    private final Set<Player> spectators;
    private final HashMap<GameTeam, Boolean> teamAliveMap;
    private final HashMap<Player, List<Player>> hiddenPlayers = new HashMap();
    private final GameScoreboard gameScoreboard;

    public Game(GameConfiguration gameConfiguration, GameManager gameManager, GameMap map) {
        int x;
        this.gameConfiguration = gameConfiguration;
        this.gameManager = gameManager;
        this.map = map;
        this.chestManager = new ChestManager(this);
        this.gameState = GameState.WAITING;
        this.id = GameManager.generateID();
        this.gamePlayers = new HashMap();
        this.startCountdown = new StartCountdown(this);
        this.chestRefillCountdown = new ChestRefillCountdown(this);
        this.maxPlayers = gameConfiguration.getMaxTeams() * gameConfiguration.getTeamSize();
        this.minPlayers = gameConfiguration.getMinTeams() * gameConfiguration.getTeamSize();
        this.gameTeams = new HashSet();
        this.teamSpawnLocations = new HashMap();
        this.alivePlayers = new HashSet();
        this.deadPlayers = new HashSet();
        this.spectators = new HashSet();
        this.teamAliveMap = new HashMap();
        this.gameScoreboard = new GameScoreboard(this, gameManager);
        for (x = 0; x < gameConfiguration.getMaxTeams(); ++x) {
            GameTeam team = new GameTeam(new Player[0]);
            this.gameTeams.add(team);
            this.teamAliveMap.put(team, true);
        }
        for (x = 0; x < gameConfiguration.getMaxTeams(); ++x) {
            this.teamSpawnLocations.put((GameTeam)this.gameTeams.stream().toList().get(x), (Location)map.getTeamSpawnLocations().get(x));
        }
        this.startCountdown.runTaskTimer((Plugin)SkywarsPlus.getInstance(), 0L, 20L);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.chestManager, (Plugin)SkywarsPlus.getInstance());
        if (map.getTeamSpawnLocations().size() < this.gameTeams.size()) {
            Bukkit.getLogger().warning("Not enough team locations in the map: %s, config: %s".formatted(map.getName(), gameConfiguration.getName()));
        }
        this.spawnCages();
    }

    public void playerJoin(Player player) {
        if (this.hasStarted()) {
            if (this.isActive()) {
                Message.send((CommandSender)player, (String)"<gray>This game already started");
            } else {
                Message.send((CommandSender)player, (String)"<gray>This game already ended");
            }
            return;
        }
        this.refreshPlayer(player);
        PlayerSession session = this.gameManager.createPlayerSession(player, this);
        this.gamePlayers.put(player, session);
        this.alivePlayers.add(player);
        player.teleport(this.map.getSpectatorLocation());
        this.assignTeam(player);
        this.teleportToTeamSpawnLocation(player);
        this.gameScoreboard.createScoreboard(player);
        this.broadcastMessage("<gold>%s<gray> joined the game <darK_gray>[<gray>%s<dark_gray>]".formatted(player.getName(), this.getPlayerCount() + "/" + this.maxPlayers));
        if (this.isWaiting()) {
            if (this.getPlayerCount() == this.minPlayers) {
                this.setGameState(GameState.STARTING);
            }
            if (this.getPlayerCount() == this.maxPlayers) {
                this.setGameState(GameState.STARTING);
                this.startCountdown.setTime(20);
            }
        }
        this.updateScoreboardPlayerCount();
    }

    public void playerLeave(Player player) {
        this.showSpectators(player);
        if (!this.hasStarted()) {
            this.getTeam(player).removePlayer(player);
            this.gamePlayers.remove(player);
            this.alivePlayers.remove(player);
            this.broadcastMessage("<gold>%s<gray> left the game <darK_gray>[<gray>%s<dark_gray>]".formatted(player.getName(), this.getPlayerCount() + "/" + this.maxPlayers));
        } else if (this.deadPlayers.contains(player)) {
            this.removeSpectator(player);
        } else {
            this.broadcastMessage("<gold>%s<gray> left the game".formatted(player.getName()));
            this.playerDie(player);
            this.removeSpectator(player);
        }
        this.gameManager.deletePlayerSession(player);
        this.refreshPlayer(player);
        player.teleport(this.gameManager.getLobbyLocation());
        player.clearTitle();
        if (this.getPlayerCount() == 0) {
            this.deleteGame();
            return;
        }
        this.gameScoreboard.removeScoreboard(player);
        if (this.isStarting() && this.getPlayerCount() < this.minPlayers) {
            this.setGameState(GameState.WAITING);
        }
        this.updateScoreboardPlayerCount();
    }

    public void playerDie(Player player) {
        if (this.spectators.contains(player)) {
            return;
        }
        PlayerSession session = this.gameManager.getPlayerSession(player);
        session.markAsDead();
        this.alivePlayers.remove(player);
        this.deadPlayers.add(player);
        this.addSpectator(player);
        PlayerConfig.addDeath((Player)player, (GameConfiguration)this.gameConfiguration);
        if (!this.isTeamAlive(this.getTeam(player))) {
            this.teamAliveMap.put(this.getTeam(player), false);
        }
        this.updateScoreboardPlayersLeft();
        this.updateScoreboardTeamsLeft();
        if (this.getAliveTeams().size() == 1) {
            this.setGameState(GameState.ENDED);
        }
    }

    public void updateScoreboardPlayersLeft() {
        this.getInGamePlayers().forEach(arg_0 -> ((GameScoreboard)this.gameScoreboard).updatePlayersLeft(arg_0));
    }

    public void updateScoreboardTeamsLeft() {
        this.getInGamePlayers().forEach(arg_0 -> ((GameScoreboard)this.gameScoreboard).updateTeamsLeft(arg_0));
    }

    public void updateScoreboardPlayerCount() {
        this.getInGamePlayers().forEach(arg_0 -> ((GameScoreboard)this.gameScoreboard).updatePlayerCount(arg_0));
    }

    public void updateScoreboardChestRefill() {
        this.getInGamePlayers().forEach(arg_0 -> ((GameScoreboard)this.gameScoreboard).updateChestRefill(arg_0));
    }

    public void updateScoreboardStartCountdown() {
        this.getInGamePlayers().forEach(arg_0 -> ((GameScoreboard)this.gameScoreboard).updateStartCountdown(arg_0));
    }

    public boolean isAlive(Player player) {
        return this.alivePlayers.contains(player);
    }

    @Nullable
    public GameTeam getTeamWon() {
        if (this.getAliveTeams().size() != 1) {
            return null;
        }
        return (GameTeam)this.getAliveTeams().stream().toList().getFirst();
    }

    public Set<Player> getDeadPlayers() {
        return this.deadPlayers;
    }

    public void broadcastMessage(String message) {
        for (Player player : this.getInGamePlayers()) {
            player.sendRichMessage(message);
        }
    }

    public void broadcastMessage(Component component) {
        for (Player player : this.getInGamePlayers()) {
            player.sendMessage(component);
        }
    }

    public void broadcastTitle(Component title, Component subtitle, Duration fadeIn, Duration stay, Duration fadeOut, @Nullable Collection<Player> players) {
        List<Object> playerList = players == null ? this.getInGamePlayers().stream().toList() : players.stream().toList();
        for (Player player : playerList) {
            player.showTitle(Title.title((Component)title, (Component)subtitle, (Title.Times)Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut)));
        }
    }

    public void broadcastTitle(Component title, Component subtitle, @Nullable Collection<Player> players) {
        List<Object> playerList = players == null ? this.getInGamePlayers().stream().toList() : players.stream().toList();
        for (Player player : playerList) {
            player.showTitle(Title.title((Component)title, (Component)subtitle));
        }
    }

    public GameConfiguration getGameConfiguration() {
        return this.gameConfiguration;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState newState) {
        GameState before = this.gameState;
        this.gameState = newState;
        this.gameManager.getGamesMenu().update();
        if (before == GameState.STARTING && newState == GameState.WAITING) {
            this.broadcastMessage("<gray>Not enough players to start");
            this.startCountdown.setTime(40);
        }
        switch (1.$SwitchMap$me$tomqnto$skywars$game$GameState[newState.ordinal()]) {
            case 1: {
                this.gameTeams.forEach(team -> {
                    if (!this.isTeamAlive(team)) {
                        this.teamAliveMap.remove(team);
                    }
                });
                this.removeCages();
                this.chestRefillCountdown.runTaskTimer((Plugin)SkywarsPlus.getInstance(), 0L, 20L);
                this.getInGamePlayers().forEach(player -> {
                    this.hiddenPlayers.put(player, new ArrayList());
                    this.gameScoreboard.registerStartedTeams(player);
                });
                for (Player player2 : this.gamePlayers.keySet()) {
                    player2.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 60, 10));
                }
                break;
            }
            case 2: {
                this.broadcastTitle((Component)Component.text((String)"VICTORY!", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), (Component)Component.empty(), (Collection)this.getTeamWon().getTeamPlayers());
                this.broadcastTitle((Component)Component.text((String)"GAME OVER!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), (Component)Component.empty(), (Collection)this.spectators);
                new EndCountdown(this).runTaskTimer((Plugin)SkywarsPlus.getInstance(), 0L, 20L);
                this.getInGamePlayers().forEach(arg_0 -> ((GameScoreboard)this.gameScoreboard).removeScoreboard(arg_0));
                this.getTeamWon().getTeamPlayers().forEach(player -> PlayerConfig.addWin((Player)player, (GameConfiguration)this.gameConfiguration));
                this.getDeadTeams().forEach(team -> team.getTeamPlayers().forEach(player -> PlayerConfig.addLoss((Player)player, (GameConfiguration)this.gameConfiguration)));
            }
        }
    }

    public GameMap getMap() {
        return this.map;
    }

    public String getId() {
        return this.id;
    }

    public HashMap<Player, PlayerSession> getGamePlayers() {
        return this.gamePlayers;
    }

    public int getPlayerCount() {
        return this.gamePlayers.size();
    }

    public void refreshPlayer(Player player) {
        player.getInventory().clear();
        player.setHealth(20.0);
        player.setFoodLevel(20);
        player.setSaturation(6.0f);
        player.setExperienceLevelAndProgress(0);
        player.clearActivePotionEffects();
        player.setGameMode(GameMode.SURVIVAL);
    }

    public void deleteGame() {
        this.map.getBukkitWorld().getPlayers().forEach(player -> {
            this.gameManager.deletePlayerSession(player);
            this.gameScoreboard.removeScoreboard(player);
            this.refreshPlayer(player);
            player.setGameMode(GameMode.SURVIVAL);
            player.teleport(this.gameManager.getLobbyLocation());
            this.showSpectators(player);
            if (this.isSpectator(player)) {
                this.removeSpectator(player);
            }
        });
        this.map.unload();
        this.gameManager.getGames().remove(this.id);
    }

    public void assignTeam(Player player) {
        List<GameTeam> teams = this.gameTeams.stream().filter(team -> team.getPlayerCount() < this.gameConfiguration.getTeamSize()).toList();
        if (teams.isEmpty()) {
            this.playerLeave(player);
            Message.send((CommandSender)player, (String)"<red>You were kicked: not enough teams to join");
        } else {
            teams.getFirst().addPlayer(player);
        }
    }

    public StartCountdown getStartCountdown() {
        return this.startCountdown;
    }

    public ChestManager getChestManager() {
        return this.chestManager;
    }

    public HashSet<Player> getAlivePlayers() {
        return this.alivePlayers;
    }

    public Set<GameTeam> getGameTeams() {
        return this.gameTeams;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public HashMap<GameTeam, Location> getTeamSpawnLocations() {
        return this.teamSpawnLocations;
    }

    public GameTeam getTeam(Player player) {
        for (GameTeam team : this.gameTeams) {
            if (!team.getTeamPlayers().contains(player)) continue;
            return team;
        }
        return null;
    }

    public void teleportToTeamSpawnLocations() {
        for (Player player : this.gamePlayers.keySet()) {
            this.teleportToTeamSpawnLocation(player);
        }
    }

    public void teleportToTeamSpawnLocation(Player player) {
        player.teleport((Location)this.teamSpawnLocations.get(this.getTeam(player)));
    }

    public void setCages(Material material) {
        int size = 1;
        int start = -2;
        for (GameTeam team : this.gameTeams) {
            Location center = ((Location)this.getTeamSpawnLocations().get(team)).clone();
            for (int x = start; x <= size; ++x) {
                for (int y = -1; y <= size + 2; ++y) {
                    for (int z = start; z <= size; ++z) {
                        boolean isEdge;
                        Location loc = center.clone().add((double)x, (double)y, (double)z);
                        Block block = loc.getBlock();
                        boolean bl = isEdge = x == start || x == size || y == -1 || y == size + 2 || z == start || z == size;
                        if (isEdge) {
                            block.setType(material);
                            continue;
                        }
                        block.setType(Material.AIR);
                    }
                }
            }
        }
    }

    public void spawnCages() {
        this.setCages(PluginConfigManager.getCageMaterial());
    }

    public void removeCages() {
        this.setCages(Material.AIR);
    }

    public Set<Player> getSpectators() {
        return this.spectators;
    }

    public Set<Player> getInGamePlayers() {
        HashSet<Player> players = new HashSet<Player>();
        players.addAll(this.getAlivePlayers());
        players.addAll(this.getSpectators());
        return players;
    }

    public Set<GameTeam> getAliveTeams() {
        return this.teamAliveMap.keySet().stream().filter(this.teamAliveMap::get).collect(Collectors.toSet());
    }

    public Set<GameTeam> getDeadTeams() {
        return this.teamAliveMap.keySet().stream().filter(team -> (Boolean)this.teamAliveMap.get(team) == false).collect(Collectors.toSet());
    }

    public boolean isTeamAlive(GameTeam team) {
        if (team.getPlayerCount() == 0) {
            return false;
        }
        return !this.deadPlayers.containsAll(team.getTeamPlayers());
    }

    public void addSpectator(Player player) {
        player.setGameMode(GameMode.SURVIVAL);
        player.setCollidable(false);
        player.setAllowFlight(true);
        player.setFlying(true);
        GameManager.getSpectatorTeam().addPlayer((OfflinePlayer)player);
        if (!this.hiddenPlayers.containsKey(player)) {
            this.hiddenPlayers.put(player, List.of());
        }
        this.hiddenPlayers.keySet().forEach(inGamePlayer -> {
            if (inGamePlayer == player) {
                return;
            }
            inGamePlayer.hidePlayer((Plugin)SkywarsPlus.getInstance(), player);
            List hidden = (List)this.hiddenPlayers.get(inGamePlayer);
            hidden.add(player);
            this.hiddenPlayers.put(inGamePlayer, hidden);
        });
        this.spectators.add(player);
    }

    public void removeSpectator(Player player) {
        player.setCollidable(true);
        GameManager.getSpectatorTeam().removePlayer((OfflinePlayer)player);
        this.hiddenPlayers.keySet().forEach(inGamePlayer -> {
            if (inGamePlayer == player) {
                return;
            }
            inGamePlayer.showPlayer((Plugin)SkywarsPlus.getInstance(), player);
            List hidden = (List)this.hiddenPlayers.get(inGamePlayer);
            hidden.remove(player);
            this.hiddenPlayers.put(inGamePlayer, hidden);
        });
        this.spectators.remove(player);
        player.setFlying(false);
    }

    public boolean isSpectator(Player player) {
        return this.spectators.contains(player);
    }

    public void showSpectators(Player player) {
        this.spectators.forEach(spectator -> player.showPlayer((Plugin)SkywarsPlus.getInstance(), spectator));
    }

    public void hideSpectators(Player player) {
        this.spectators.forEach(spectator -> player.hidePlayer((Plugin)SkywarsPlus.getInstance(), spectator));
    }

    public ChestRefillCountdown getChestRefillCountdown() {
        return this.chestRefillCountdown;
    }

    public GameScoreboard getGameScoreboard() {
        return this.gameScoreboard;
    }

    public boolean hasStarted() {
        return this.gameState == GameState.STARTED || this.gameState == GameState.ENDED;
    }

    public boolean hasEnded() {
        return this.gameState == GameState.ENDED;
    }

    public boolean isWaiting() {
        return this.gameState == GameState.WAITING;
    }

    public boolean isStarting() {
        return this.gameState == GameState.STARTING;
    }

    public boolean isActive() {
        return this.gameState == GameState.STARTED;
    }
}

