/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;

public class GameConfiguration
implements ConfigurationSerializable {
    private final String name;
    private final int minTeams;
    private final int maxTeams;
    private final int teamSize;
    private final int maxArmorPiecesNormalChest;
    private final int maxArmorPiecesOPChest;
    private final int chestRefillCooldown;
    private final String[] allowedMapIDs;

    public GameConfiguration(String name, int minTeams, int maxTeams, int teamSize, int maxArmorPiecesNormalChest, int maxArmorPiecesOPChest, int chestRefillCooldown, String ... allowedMapIDs) {
        this.maxTeams = maxTeams;
        this.minTeams = minTeams;
        this.name = name;
        this.teamSize = teamSize;
        this.maxArmorPiecesNormalChest = maxArmorPiecesNormalChest;
        this.maxArmorPiecesOPChest = maxArmorPiecesOPChest;
        this.chestRefillCooldown = chestRefillCooldown;
        this.allowedMapIDs = allowedMapIDs;
    }

    public int getMaxTeams() {
        return this.maxTeams;
    }

    public int getMinTeams() {
        return this.minTeams;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAllowedMapIDs() {
        return this.allowedMapIDs;
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("min-teams", this.minTeams);
        map.put("max-teams", this.maxTeams);
        map.put("team-size", this.teamSize);
        map.put("max-armor-normal-chest", this.maxArmorPiecesNormalChest);
        map.put("max-armor-op-chest", this.maxArmorPiecesOPChest);
        map.put("chest-refill-cooldown", this.chestRefillCooldown);
        map.put("map-ids", this.allowedMapIDs);
        return map;
    }

    public static GameConfiguration deserialize(Map<String, Object> map) {
        String name = (String)map.get("name");
        int minTeams = (Integer)map.get("min-teams");
        int maxTeams = (Integer)map.get("max-teams");
        int teamSize = (Integer)map.get("team-size");
        int chestRefillCooldown = (Integer)map.get("chest-refill-cooldown");
        int maxArmorNormal = (Integer)map.get("max-armor-normal-chest");
        int maxArmorOP = (Integer)map.get("max-armor-op-chest");
        List ids = (List)map.get("map-ids");
        String[] allowedMapIDs = ids.toArray(new String[0]);
        return new GameConfiguration(name, minTeams, maxTeams, teamSize, maxArmorNormal, maxArmorOP, chestRefillCooldown, allowedMapIDs);
    }

    public int getTeamSize() {
        return this.teamSize;
    }

    public int getChestRefillCooldown() {
        return this.chestRefillCooldown;
    }

    public int getMaxArmorPiecesNormalChest() {
        return this.maxArmorPiecesNormalChest;
    }

    public int getMaxArmorPiecesOPChest() {
        return this.maxArmorPiecesOPChest;
    }
}

