/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.util.HashMap;
import java.util.List;
import me.tomqnto.skywars.Message;
import me.tomqnto.skywars.game.Game;
import me.tomqnto.skywars.game.GameConfiguration;
import me.tomqnto.skywars.game.GameManager;
import me.tomqnto.skywars.game.GameState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

/*
 * Exception performing whole class analysis ignored.
 */
public class GameJoinHandler {
    private static final List<GameState> requiredStates = List.of(GameState.STARTING, GameState.WAITING);

    public static void joinGame(Player player, GameConfiguration gameSettings, GameManager gameManager) {
        if (gameManager.hasActiveSession(player)) {
            return;
        }
        HashMap games = gameManager.getGames();
        if (!games.isEmpty()) {
            for (Game game : games.values()) {
                if (gameSettings != game.getGameConfiguration() || game.getPlayerCount() >= game.getMaxPlayers() || !requiredStates.contains(game.getGameState())) continue;
                GameJoinHandler.sendJoinMessage((Player)player, (String)game.getId());
                game.playerJoin(player);
                return;
            }
        } else {
            Game game = gameManager.createGame(gameSettings);
            if (game != null) {
                GameJoinHandler.sendJoinMessage((Player)player, (String)game.getId());
                game.playerJoin(player);
                return;
            }
        }
        Message.send((CommandSender)player, (String)"<red>Could not find a game to join");
    }

    public static void joinGame(Player player, String id, GameManager gameManager) {
        Game game = (Game)gameManager.getGames().get(id);
        if (game == null) {
            Message.send((CommandSender)player, (String)"<red>This game does not exist");
            return;
        }
        if (game.getGameState() == GameState.STARTING || game.getGameState() == GameState.WAITING) {
            GameJoinHandler.sendJoinMessage((Player)player, (String)id);
            game.playerJoin(player);
        }
    }

    public static void sendJoinMessage(Player player, String id) {
        Message.send((CommandSender)player, (String)"<gray>Joined %s".formatted(id));
    }
}

