/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.game;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.tomqnto.skywars.SkywarsPlus;
import me.tomqnto.skywars.configs.MapConfig;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.codehaus.plexus.util.FileUtils;

public class GameMap {
    private final File sourceWorldFolder;
    private final String worldName;
    private File activeWorldFolder;
    private World bukkitWorld;

    public GameMap(String worldName) {
        this.worldName = worldName;
        this.sourceWorldFolder = new File(new File(SkywarsPlus.getInstance().getDataFolder(), "maps"), worldName);
        this.load();
    }

    public boolean load() {
        if (this.isLoaded()) {
            return true;
        }
        System.out.println(this.activeWorldFolder);
        this.activeWorldFolder = new File(Bukkit.getWorldContainer(), this.sourceWorldFolder.getName() + "_active_" + System.currentTimeMillis());
        try {
            FileUtils.copyDirectoryStructure((File)this.sourceWorldFolder, (File)this.activeWorldFolder);
            this.bukkitWorld = Bukkit.createWorld((WorldCreator)new WorldCreator(this.activeWorldFolder.getName()).keepSpawnLoaded(TriState.FALSE));
            if (this.bukkitWorld != null) {
                this.bukkitWorld.setAutoSave(false);
                this.bukkitWorld.setPVP(true);
                this.bukkitWorld.setVoidDamageAmount(10000.0f);
                this.bukkitWorld.getPersistentDataContainer().set(new NamespacedKey((Plugin)SkywarsPlus.getInstance(), "skywars_map"), PersistentDataType.BOOLEAN, (Object)true);
                this.bukkitWorld.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
                this.bukkitWorld.setGameRule(GameRule.KEEP_INVENTORY, (Object)false);
                this.bukkitWorld.setGameRule(GameRule.DO_IMMEDIATE_RESPAWN, (Object)true);
                this.bukkitWorld.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
                this.bukkitWorld.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
                this.bukkitWorld.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Could not load world: " + this.activeWorldFolder.getName());
            e.printStackTrace();
            return false;
        }
        return this.isLoaded();
    }

    public void unload() {
        if (this.bukkitWorld != null) {
            Bukkit.unloadWorld((World)this.bukkitWorld, (boolean)false);
        }
        if (this.activeWorldFolder != null) {
            try {
                FileUtils.deleteDirectory((File)this.activeWorldFolder);
                Bukkit.getLogger().info("Deleted active world: " + this.activeWorldFolder.getName());
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("Could not delete active world: " + this.activeWorldFolder.getName());
                e.printStackTrace();
            }
        }
        this.bukkitWorld = null;
        this.activeWorldFolder = null;
    }

    private boolean isLoaded() {
        return this.bukkitWorld != null;
    }

    public World getBukkitWorld() {
        return this.bukkitWorld;
    }

    public String getName() {
        return this.worldName;
    }

    public List<Location> getTeamSpawnLocations() {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (List coordsList : MapConfig.getTeamSpawnCoordinates((String)this.getName())) {
            locations.add(new Location(this.bukkitWorld, ((Double)coordsList.getFirst()).doubleValue(), ((Double)coordsList.get(1)).doubleValue(), ((Double)coordsList.getLast()).doubleValue()));
        }
        return locations;
    }

    public Location getSpectatorLocation() {
        List coords = MapConfig.getSpectatorTeleportLocation((String)this.getName());
        return new Location(this.bukkitWorld, ((Double)coords.getFirst()).doubleValue(), ((Double)coords.get(1)).doubleValue(), ((Double)coords.getLast()).doubleValue());
    }

    public List<Location> getOPChestLocations() {
        List intList = MapConfig.getOPChestLocations((String)this.getName());
        ArrayList<Location> locationList = new ArrayList<Location>();
        for (List intLocations : intList) {
            int x = (Integer)intLocations.getFirst();
            int y = (Integer)intLocations.get(1);
            int z = (Integer)intLocations.getLast();
            locationList.add(new Location(this.getBukkitWorld(), (double)x, (double)y, (double)z));
        }
        return locationList;
    }
}

