/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skywars.tasks;

import me.tomqnto.skywars.game.Game;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class ChestRefillCountdown
extends BukkitRunnable {
    private final Game game;
    private final int REFILL_TIME;
    private int secondsLeft;
    private String timeLeftFormatted;

    public ChestRefillCountdown(Game game) {
        this.game = game;
        this.secondsLeft = this.REFILL_TIME = game.getGameConfiguration().getChestRefillCooldown();
    }

    public void run() {
        this.timeLeftFormatted = DurationFormatUtils.formatDuration((long)((long)this.secondsLeft * 1000L), (String)"mm':'ss");
        if (this.game.isActive()) {
            this.game.updateScoreboardChestRefill();
            for (Player player : this.game.getInGamePlayers()) {
                player.sendActionBar((Component)Component.text((String)"Chests refill in %s".formatted(this.timeLeftFormatted)));
            }
            if (this.secondsLeft == 0) {
                this.game.getChestManager().resetChests();
                this.game.broadcastTitle((Component)Component.text((String)"All chests refilled!", (TextColor)NamedTextColor.YELLOW, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), (Component)Component.empty(), null);
                this.secondsLeft = this.REFILL_TIME;
            }
            --this.secondsLeft;
        } else {
            this.cancel();
        }
    }

    public String getTimeLeftFormatted() {
        if (this.timeLeftFormatted == null) {
            return "null";
        }
        return this.timeLeftFormatted;
    }
}

