/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.command.arguments;

import java.util.List;
import java.util.Objects;
import me.tomqnto.skyWars.Message;
import me.tomqnto.skyWars.command.ArgumentExecutor;
import me.tomqnto.skyWars.configs.LootItemsConfig;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class AddLootItemsArgument
implements ArgumentExecutor {
    @Override
    public void execute(CommandSender sender, String[] args) {
        BlockState inv;
        BlockState blockState;
        if (!(sender instanceof Player)) {
            Message.PLAYER_ONLY_COMMAND.send(sender);
            return;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            Message.MISSING_OR_INVALID_ARGUMENTS.send((CommandSender)player);
            return;
        }
        if (!List.of("normal", "middle").contains(args[1])) {
            Message.MISSING_OR_INVALID_ARGUMENTS.send((CommandSender)player);
            return;
        }
        Block block = player.getTargetBlockExact(5);
        if (block != null && (blockState = block.getState()) instanceof DoubleChest) {
            DoubleChest chest = (DoubleChest)blockState;
            inv = chest.getInventory();
            LootItemsConfig.addLootItems((Inventory)inv, Objects.equals(args[1], "middle"));
        } else if (block != null && (inv = block.getState()) instanceof Chest) {
            Chest chest = (Chest)inv;
            inv = chest.getBlockInventory();
            LootItemsConfig.addLootItems((Inventory)inv, Objects.equals(args[1], "middle"));
        } else {
            Message.send((CommandSender)player, "<red>You must be looking at a chest");
            return;
        }
        Message.send((CommandSender)player, "<green>Successfully set loot items for %s chests".formatted(args[1]));
    }

    @Override
    public String getUsage() {
        return "/skywars addloot <normal | middle>";
    }

    @Override
    public String getDescription() {
        return "Adds items for the loot items of normal/middle chests";
    }
}

