/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.command.arguments;

import me.tomqnto.skyWars.Message;
import me.tomqnto.skyWars.command.ArgumentExecutor;
import me.tomqnto.skyWars.configs.GameSettingsConfig;
import me.tomqnto.skyWars.game.GameJoinHandler;
import me.tomqnto.skyWars.game.GameManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JoinGameArgument
implements ArgumentExecutor {
    private final GameManager gameManager;

    public JoinGameArgument(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Message.PLAYER_ONLY_COMMAND.send(sender);
            return;
        }
        Player player = (Player)sender;
        if (this.gameManager.hasActiveSession(player)) {
            Message.COMMAND_NOT_ALLOWED_IN_GAME.send((CommandSender)player);
            return;
        }
        if (args.length == 1) {
            Message.MISSING_OR_INVALID_ARGUMENTS.send((CommandSender)player);
            return;
        }
        if (args.length == 2) {
            if (args[1].startsWith("id:")) {
                GameJoinHandler.joinGame(player, args[1].substring(4), this.gameManager);
            } else if (GameSettingsConfig.doesExist(args[1])) {
                GameJoinHandler.joinGame(player, GameSettingsConfig.getGameSettings(args[1]), this.gameManager);
            } else {
                Message.send((CommandSender)player, "<red>Invalid mode or id");
            }
        }
    }

    @Override
    public String getUsage() {
        return "/skywars join <id:gameid | mode>";
    }

    @Override
    public String getDescription() {
        return "Used to join a game";
    }
}

