/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.command.arguments;

import me.tomqnto.skyWars.Message;
import me.tomqnto.skyWars.command.ArgumentExecutor;
import me.tomqnto.skyWars.game.GameManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LeaveGameArgument
implements ArgumentExecutor {
    private final GameManager gameManager;

    public LeaveGameArgument(GameManager gameManager) {
        this.gameManager = gameManager;
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            Message.PLAYER_ONLY_COMMAND.send(sender);
            return;
        }
        Player player = (Player)sender;
        if (!this.gameManager.hasActiveSession(player)) {
            Message.COMMAND_ONLY_IN_GAME.send((CommandSender)player);
            return;
        }
        Message.send((CommandSender)player, "<gray>Left %s".formatted(this.gameManager.getPlayerSession(player).getGame().getId()));
        this.gameManager.getPlayerSession(player).getGame().playerLeave(player);
    }

    @Override
    public String getUsage() {
        return "/skywars leave";
    }

    @Override
    public String getDescription() {
        return "Used to leave the game";
    }
}

