/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.configs;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import me.tomqnto.skyWars.SkyWars;
import me.tomqnto.skyWars.game.GameSettings;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class GameSettingsConfig {
    private static final File file = new File(SkyWars.getInstance().getDataFolder(), "game_settings.yml");
    private static FileConfiguration config;

    public static void load() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void saveConfig() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GameSettingsConfig.load();
    }

    public static void saveGameSettings(GameSettings gameSettings) {
        config.set("game-settings." + gameSettings.getName(), (Object)gameSettings);
        GameSettingsConfig.saveConfig();
    }

    public static void deleteGameSettings(String name) {
        config.set("game-settings." + name, null);
        GameSettingsConfig.saveConfig();
    }

    @Nullable
    public static GameSettings getGameSettings(String name) {
        return (GameSettings)config.getObject("game-settings." + name, GameSettings.class);
    }

    public static boolean doesExist(String name) {
        return GameSettingsConfig.getGameSettings(name) != null;
    }

    public static Set<GameSettings> getSavedGameSettings() {
        HashSet<GameSettings> settingsSet = new HashSet<GameSettings>();
        ConfigurationSection section = config.getConfigurationSection("game-settings");
        if (section == null) {
            return settingsSet;
        }
        for (String name : section.getKeys(false)) {
            settingsSet.add(GameSettingsConfig.getGameSettings(name));
        }
        return settingsSet;
    }

    static {
        if (!file.exists()) {
            SkyWars.getInstance().saveResource("game_settings.yml", false);
        }
        GameSettingsConfig.load();
    }
}

