/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.configs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.tomqnto.skyWars.SkyWars;
import org.bukkit.configuration.file.YamlConfiguration;

public class MapConfig {
    private static final File file = new File(SkyWars.getInstance().getDataFolder(), "map_data.yml");
    private static YamlConfiguration config;

    public static void load() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void saveConfig() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MapConfig.load();
    }

    public static List<String> getMaps() {
        ArrayList<String> maps = new ArrayList<String>();
        for (String map : config.getKeys(false)) {
            File mapFolder = new File(new File(SkyWars.getInstance().getDataFolder(), "maps"), map);
            if (!mapFolder.exists()) continue;
            maps.add(map);
        }
        return maps;
    }

    public static List<List<Integer>> getChestCoordinates(String map) {
        List list = (List)config.get(map + ".chest-locations");
        if (list == null || list.isEmpty()) {
            return List.of();
        }
        return list;
    }

    public static List<Double> getWaitingAreaCoordinates(String map) {
        return config.getDoubleList(map + ".waiting-area-location");
    }

    public static List<List<Double>> getTeamSpawnCoordinates(String map) {
        return (List)config.get(map + ".team-spawn-locations");
    }

    static {
        if (!file.exists()) {
            SkyWars.getInstance().saveResource("map_data.yml", false);
        }
        MapConfig.load();
    }
}

