/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.game;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.tomqnto.skyWars.configs.LootItemsConfig;
import me.tomqnto.skyWars.game.Game;
import me.tomqnto.skyWars.game.GameMap;
import me.tomqnto.skyWars.game.LootItem;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ChestManager
implements Listener {
    private final GameMap map;
    private final World world;
    private final Set<Location> defaultNormalChestLocations = new HashSet<Location>();
    private final Set<Location> defaultMiddleChestLocations = new HashSet<Location>();
    private final Set<Location> playerPlacedChestLocations = new HashSet<Location>();
    private final Set<Location> openedChests = new HashSet<Location>();
    private final List<LootItem> normalChestItems = new ArrayList<LootItem>();
    private final List<LootItem> middleChestItems = new ArrayList<LootItem>();

    public ChestManager(Game game) {
        ConfigurationSection section;
        this.map = game.getMap();
        this.world = this.map.getBukkitWorld();
        this.defaultMiddleChestLocations.addAll(this.map.getChestLocations());
        ConfigurationSection normalChestItemsSection = LootItemsConfig.getNormalChestItemsSection();
        ConfigurationSection middleChestItemsSection = LootItemsConfig.getMiddleChestItemsSection();
        if (normalChestItemsSection == null || middleChestItemsSection == null) {
            Bukkit.getLogger().severe("Please setup your 'loot-items' in loot-items.yml");
        }
        for (String key : normalChestItemsSection.getKeys(false)) {
            section = normalChestItemsSection.getConfigurationSection(key);
            this.normalChestItems.add(new LootItem(section));
        }
        for (String key : middleChestItemsSection.getKeys(false)) {
            section = middleChestItemsSection.getConfigurationSection(key);
            this.middleChestItems.add(new LootItem(section));
        }
    }

    @EventHandler
    public void onChestPlace(BlockPlaceEvent event) {
        if (event.getBlockPlaced().getWorld() != this.world) {
            return;
        }
        if (!(event.getBlockPlaced().getType() != Material.CHEST || this.defaultNormalChestLocations.contains(event.getBlockPlaced().getLocation()) && this.defaultMiddleChestLocations.contains(event.getBlockPlaced().getLocation()))) {
            this.playerPlacedChestLocations.add(event.getBlockPlaced().getLocation());
        }
    }

    @EventHandler
    public void onChestBreak(BlockBreakEvent event) {
        if (event.getBlock().getWorld() != this.world) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        if (blockState instanceof Chest) {
            Chest chest = (Chest)blockState;
            this.checkChest(chest);
        }
    }

    @EventHandler
    public void onChestOpen(InventoryOpenEvent event) {
        if (event.getPlayer().getWorld() != this.world) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            this.checkChest(chest);
        }
    }

    public void fill(Inventory inventory, boolean isMiddleChest) {
        inventory.clear();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        HashSet<LootItem> normalUsed = new HashSet<LootItem>();
        HashSet<LootItem> middleUsed = new HashSet<LootItem>();
        for (int slotIndex = 0; slotIndex < inventory.getSize(); ++slotIndex) {
            LootItem randomItem = this.normalChestItems.get(random.nextInt(this.normalChestItems.size()));
            if (isMiddleChest) {
                randomItem = this.middleChestItems.get(random.nextInt(this.middleChestItems.size()));
            }
            if (!isMiddleChest) {
                if (normalUsed.contains(randomItem)) continue;
                normalUsed.add(randomItem);
            } else {
                if (middleUsed.contains(randomItem)) continue;
                middleUsed.add(randomItem);
            }
            if (!randomItem.shouldFill(random)) continue;
            ItemStack itemStack = randomItem.make(random);
            inventory.setItem(slotIndex, itemStack);
        }
    }

    public void markAsOpened(Location location) {
        this.openedChests.add(location);
    }

    public boolean hasBeenOpened(Location location) {
        return this.openedChests.contains(location);
    }

    public void resetChests() {
        this.openedChests.clear();
        this.defaultNormalChestLocations.forEach(location -> {
            BlockState patt0$temp = location.getBlock().getState();
            if (patt0$temp instanceof Chest) {
                Chest chest = (Chest)patt0$temp;
                this.checkChest(chest);
            }
        });
        this.defaultMiddleChestLocations.forEach(location -> {
            BlockState patt0$temp = location.getBlock().getState();
            if (patt0$temp instanceof Chest) {
                Chest chest = (Chest)patt0$temp;
                this.checkChest(chest);
            }
        });
    }

    public void checkChest(Chest chest) {
        boolean playerPlaced = this.playerPlacedChestLocations.contains(chest.getLocation());
        boolean defaultNormalChest = this.defaultNormalChestLocations.contains(chest.getLocation());
        boolean defaultMiddleChest = this.defaultMiddleChestLocations.contains(chest.getLocation());
        if (playerPlaced && !defaultNormalChest && !defaultMiddleChest) {
            return;
        }
        if (!this.hasBeenOpened(chest.getLocation())) {
            this.markAsOpened(chest.getLocation());
            if (defaultMiddleChest) {
                this.fill(chest.getBlockInventory(), true);
            } else {
                this.defaultNormalChestLocations.add(chest.getLocation());
                this.fill(chest.getBlockInventory(), false);
            }
        }
    }
}

