/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.skyWars.game;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.tomqnto.skyWars.Message;
import me.tomqnto.skyWars.SkyWars;
import me.tomqnto.skyWars.game.ChestManager;
import me.tomqnto.skyWars.game.GameManager;
import me.tomqnto.skyWars.game.GameMap;
import me.tomqnto.skyWars.game.GameSettings;
import me.tomqnto.skyWars.game.GameState;
import me.tomqnto.skyWars.game.GameTeam;
import me.tomqnto.skyWars.game.PlayerSession;
import me.tomqnto.skyWars.tasks.ChestRefillCountdown;
import me.tomqnto.skyWars.tasks.EndCountdown;
import me.tomqnto.skyWars.tasks.StartCountdown;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class Game {
    private final GameSettings gameSettings;
    private final GameManager gameManager;
    private final GameMap map;
    private final ChestManager chestManager;
    private GameState gameState;
    private final String id;
    private final HashMap<Player, PlayerSession> gamePlayers;
    private final Set<GameTeam> gameTeams;
    private final StartCountdown startCountdown;
    private final ChestRefillCountdown chestRefillCountdown;
    private final HashSet<PlayerSession> alivePlayers;
    private final HashSet<PlayerSession> deadPlayers;
    private final HashMap<GameTeam, Location> teamSpawnLocations;
    private final int minPlayers;
    private final int maxPlayers;
    private final Set<Player> spectators;

    public Game(GameSettings gameSettings, GameManager gameManager, GameMap map) {
        int x;
        this.gameSettings = gameSettings;
        this.gameManager = gameManager;
        this.map = map;
        this.chestManager = new ChestManager(this);
        this.gameState = GameState.WAITING;
        this.id = GameManager.GameIdGenerator();
        this.gamePlayers = new HashMap();
        this.startCountdown = new StartCountdown(this);
        this.chestRefillCountdown = new ChestRefillCountdown(this);
        this.maxPlayers = gameSettings.getMaxTeams() * gameSettings.getTeamSize();
        this.minPlayers = gameSettings.getMinTeams() * gameSettings.getTeamSize();
        this.gameTeams = new HashSet<GameTeam>();
        this.teamSpawnLocations = new HashMap();
        this.alivePlayers = new HashSet();
        this.deadPlayers = new HashSet();
        this.spectators = new HashSet<Player>();
        System.out.println("minTeams = " + gameSettings.getMinTeams());
        System.out.println("maxTeams = " + gameSettings.getMaxTeams());
        System.out.println("teamSize = " + gameSettings.getTeamSize());
        System.out.println("minPlayers = " + this.minPlayers);
        System.out.println("maxPlayers = " + this.maxPlayers);
        for (x = 0; x < gameSettings.getMaxTeams(); ++x) {
            this.gameTeams.add(new GameTeam(new Player[0]));
        }
        for (x = 0; x < gameSettings.getMaxTeams(); ++x) {
            this.teamSpawnLocations.put((GameTeam)this.gameTeams.stream().toList().get(x), map.getTeamSpawnLocations().get(x));
        }
        this.startCountdown.runTaskTimer((Plugin)SkyWars.getInstance(), 0L, 20L);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.chestManager, (Plugin)SkyWars.getInstance());
        this.alivePlayers.addAll(this.gamePlayers.values());
        if (map.getTeamSpawnLocations().size() < this.gameTeams.size()) {
            Bukkit.getLogger().severe("Not enough team spawns for game setting: %s in map: %s".formatted(gameSettings.getName(), map.getName()));
        }
    }

    public void playerJoin(Player player) {
        if (this.gameState == GameState.STARTED || this.gameState == GameState.ENDED) {
            if (this.gameState == GameState.STARTED) {
                Message.send((CommandSender)player, "<gray>This game already started");
            } else {
                Message.send((CommandSender)player, "<gray>This game already ended");
            }
            return;
        }
        this.refreshPlayer(player);
        PlayerSession session = this.gameManager.createPlayerSession(player, this);
        this.gamePlayers.put(player, session);
        player.teleport(this.map.getWaitingArea());
        this.assignTeam(player);
        this.broadcastMessage("<gold>%s<gray> joined the game <darK_gray>[<gray>%s<dark_gray>]".formatted(player.getName(), this.getPlayerCount() + "/" + this.maxPlayers));
        if (this.gameState == GameState.WAITING) {
            if (this.getPlayerCount() == this.minPlayers) {
                this.setGameState(GameState.STARTING);
            }
            if (this.getPlayerCount() == this.maxPlayers) {
                this.setGameState(GameState.STARTING);
                this.startCountdown.setTime(20);
            }
        }
    }

    public void playerLeave(Player player) {
        if (this.gameState == GameState.WAITING || this.gameState == GameState.STARTING) {
            this.getTeam(player).removePlayer(player);
            this.gamePlayers.remove(player);
            this.broadcastMessage("<gold>%s<gray> left the game <darK_gray>[<gray>%s<dark_gray>]".formatted(player.getName(), this.getPlayerCount() + "/" + this.maxPlayers));
        } else {
            this.broadcastMessage("<gold>%s<gray> left the game".formatted(player.getName()));
            this.playerDie(player);
            this.spectators.remove(player);
        }
        this.gameManager.deletePlayerSession(player);
        this.refreshPlayer(player);
        player.teleport(this.gameManager.getLobbyLocation());
        if (this.getPlayerCount() == 0) {
            this.deleteGame();
            return;
        }
        if (this.gameState == GameState.STARTING && this.getPlayerCount() < this.minPlayers) {
            this.setGameState(GameState.WAITING);
        }
    }

    public void playerDie(Player player) {
        if (this.gameManager.getPlayerSession(player).isDead()) {
            return;
        }
        PlayerSession session = this.gameManager.getPlayerSession(player);
        session.markAsDead();
        this.getTeam(player).removePlayer(player);
        this.alivePlayers.remove(session);
        this.deadPlayers.add(session);
        this.spectators.add(player);
        if (this.getAliveTeams().size() == 1) {
            this.setGameState(GameState.ENDED);
        }
        player.setGameMode(GameMode.SPECTATOR);
    }

    public Set<GameTeam> getAliveTeams() {
        return this.gameTeams.stream().filter(team -> team.getPlayerCount() > 0).collect(Collectors.toSet());
    }

    @Nullable
    public GameTeam getTeamWon() {
        if (this.getAliveTeams().size() != 1) {
            return null;
        }
        return (GameTeam)this.getAliveTeams().stream().toList().getFirst();
    }

    public Set<PlayerSession> getDeadPlayers() {
        return this.deadPlayers;
    }

    public void broadcastMessage(String message) {
        for (Player player : this.gamePlayers.keySet()) {
            player.sendRichMessage(message);
        }
    }

    public void broadcastMessage(Component component) {
        for (Player player : this.gamePlayers.keySet()) {
            player.sendMessage(component);
        }
    }

    public void broadcastTitle(Component title, Component subtitle, Duration fadeIn, Duration stay, Duration fadeOut, @Nullable Collection<Player> players) {
        List playerList = Objects.requireNonNullElseGet(players, this.gamePlayers::keySet).stream().toList();
        for (Player player : playerList) {
            player.showTitle(Title.title((Component)title, (Component)subtitle, (Title.Times)Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut)));
        }
    }

    public void broadcastTitle(Component title, Component subtitle, @Nullable Collection<Player> players) {
        List playerList = Objects.requireNonNullElseGet(players, this.gamePlayers::keySet).stream().toList();
        for (Player player : playerList) {
            player.showTitle(Title.title((Component)title, (Component)subtitle));
        }
    }

    public GameSettings getGameSettings() {
        return this.gameSettings;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState newState) {
        GameState before = this.gameState;
        this.gameState = newState;
        this.gameManager.getGamesMenu().update();
        if (before == GameState.STARTING && newState == GameState.WAITING) {
            this.gamePlayers.keySet().forEach(player -> player.teleport(this.map.getWaitingArea()));
            this.broadcastMessage("<gray>Not enough players to start");
            this.startCountdown.setTime(60);
        }
        switch (newState) {
            case STARTING: {
                this.spawnCages();
                this.teleportToTeamSpawnLocations();
                break;
            }
            case STARTED: {
                this.removeCages();
                this.chestRefillCountdown.runTaskTimer((Plugin)SkyWars.getInstance(), 0L, 20L);
                for (Player player2 : this.gamePlayers.keySet()) {
                    player2.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 60, 10));
                }
                break;
            }
            case ENDED: {
                this.broadcastTitle((Component)Component.text((String)"Victory!", (TextColor)NamedTextColor.GOLD, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), (Component)Component.empty(), this.getTeamWon().getTeamPlayers());
                this.broadcastTitle((Component)Component.text((String)"Game Over!", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), (Component)Component.empty(), this.spectators);
                new EndCountdown(this).runTaskTimer((Plugin)SkyWars.getInstance(), 0L, 20L);
            }
        }
    }

    public GameMap getMap() {
        return this.map;
    }

    public String getId() {
        return this.id;
    }

    public HashMap<Player, PlayerSession> getGamePlayers() {
        return this.gamePlayers;
    }

    public int getPlayerCount() {
        return this.gamePlayers.size();
    }

    public void refreshPlayer(Player player) {
        player.getInventory().clear();
        player.setHealth(20.0);
        player.setSaturation(20.0f);
        player.setGameMode(GameMode.SURVIVAL);
    }

    public void deleteGame() {
        this.map.getBukkitWorld().getPlayers().forEach(player -> {
            this.gameManager.deletePlayerSession((Player)player);
            this.refreshPlayer((Player)player);
            player.setGameMode(GameMode.SURVIVAL);
            player.teleport(this.gameManager.getLobbyLocation());
        });
        this.map.unload();
        this.gameManager.getGames().remove(this.id);
    }

    public void assignTeam(Player player) {
        List<GameTeam> teams = this.gameTeams.stream().filter(team -> team.getPlayerCount() < this.gameSettings.getTeamSize()).toList();
        if (teams.isEmpty()) {
            this.playerLeave(player);
            Message.send((CommandSender)player, "<red>You were kicked: not enough teams to join");
        } else {
            teams.getFirst().addPlayer(player);
        }
    }

    public StartCountdown getStartCountdown() {
        return this.startCountdown;
    }

    public ChestManager getChestManager() {
        return this.chestManager;
    }

    public HashSet<PlayerSession> getAlivePlayers() {
        return this.alivePlayers;
    }

    public Set<GameTeam> getGameTeams() {
        return this.gameTeams;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public HashMap<GameTeam, Location> getTeamSpawnLocations() {
        return this.teamSpawnLocations;
    }

    public GameTeam getTeam(Player player) {
        for (GameTeam team : this.gameTeams) {
            if (!team.getTeamPlayers().contains(player)) continue;
            return team;
        }
        return null;
    }

    public void teleportToTeamSpawnLocations() {
        for (GameTeam team : this.gameTeams) {
            team.getTeamPlayers().forEach(player -> player.teleport(this.teamSpawnLocations.get(team)));
        }
    }

    public void setCages(Material material) {
        int size = 2;
        int start = -2;
        int end = size;
        for (GameTeam team : this.gameTeams) {
            Location center = this.getTeamSpawnLocations().get(team).clone();
            for (int x = start; x <= end; ++x) {
                for (int y = start; y <= end; ++y) {
                    for (int z = start; z <= end; ++z) {
                        boolean isEdge;
                        Location loc = center.clone().add((double)x, (double)y, (double)z);
                        Block block = loc.getBlock();
                        boolean bl = isEdge = x == start || x == end || y == start || y == end || z == start || z == end;
                        if (isEdge) {
                            block.setType(material);
                            continue;
                        }
                        block.setType(Material.AIR);
                    }
                }
            }
        }
    }

    public void spawnCages() {
        this.setCages(Material.GLASS);
    }

    public void removeCages() {
        this.setCages(Material.AIR);
    }
}

